/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.util.IndentingWriter;
import com.softsynth.wire.ExternalPortModule;
import com.softsynth.wire.Module;
import com.softsynth.wire.OutputPortJack;
import com.softsynth.wire.OutputSynthWireJack;
import com.softsynth.wire.SynthWireJack;
import com.softsynth.wire.WireJack;
import java.io.IOException;

class OutputPort
extends ExternalPortModule {
    @Override
    public void setupJacks() {
        this.portJack = new OutputPortJack(this, "input");
        this.addJackCanvas(this.portJack);
        this.addJackToPatch();
        this.setName(this.getName());
    }

    @Override
    WireJack getJack(String name, int partIndex) {
        return super.getJack("input", partIndex);
    }

    public void addJackToPatch() {
        OutputSynthWireJack jack = new OutputSynthWireJack((Module)this.patch, this.getName(), this.portJack.getSynthPort());
        this.exportedJack = jack;
        this.patch.addJackCanvas(jack);
    }

    @Override
    public void generateSource(IndentingWriter writer, int phase) throws IOException {
        SynthWireJack connected = (SynthWireJack)this.portJack.getConnected(0);
        if (connected == null) {
            return;
        }
        String name = this.getName();
        switch (phase) {
            case 0: {
                if (name.equals("output")) break;
                writer.println("public SynthOutput " + name + ";");
                break;
            }
            case 2: {
                writer.println("addPort( " + name + " = " + connected.getSourceName() + ", \"" + name + "\" );");
            }
        }
    }
}

