/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.util.IndentingWriter;
import com.softsynth.wire.Module;
import com.softsynth.wire.SaveAsStream;
import com.softsynth.wire.Wire;
import com.softsynth.wire.WireException;
import com.softsynth.wire.engine.WireMessage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.io.IOException;
import java.util.Vector;

class WireJack {
    Component comp = null;
    Point tiePoint = null;
    boolean highlighted = false;
    Module dragged = null;
    Module module;
    Vector connected;
    int maxConnected = 0;
    int partIndex = 0;
    double value = 0.0;
    double min = 0.0;
    double max = 1.0;
    String name;
    private int supportMask = 0;

    WireJack(Module module, Component comp, String name) {
        this.module = module;
        this.comp = comp;
        this.connected = new Vector();
        this.setName(name);
        this.setup();
    }

    void setup() {
    }

    public Module getModule() {
        return this.module;
    }

    public Component getComponent() {
        return this.comp;
    }

    public void setMaxConnected(int max) {
        this.maxConnected = max < 0 ? 0 : max;
    }

    public int getMaxConnected() {
        return this.maxConnected;
    }

    public int getConnectedCount() {
        return this.connected.size();
    }

    public WireJack getConnected(int index) {
        return (WireJack)this.connected.elementAt(index);
    }

    public boolean isOutput() {
        return false;
    }

    public void setSupportMask(int mask) {
        this.supportMask = mask;
    }

    public int getSupportMask() {
        return this.supportMask;
    }

    public void orSupportMask(int mask) {
        this.supportMask |= mask;
    }

    public int getPartIndex() {
        return this.partIndex;
    }

    public void setPartIndex(int partIndex) {
        this.partIndex = partIndex;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDragged(Module dragged) {
        this.dragged = dragged;
    }

    public Module getDragged() {
        return this.dragged;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
        if (this.comp != null) {
            this.comp.repaint();
        }
    }

    public boolean getHighlighted() {
        return this.highlighted;
    }

    public Point getTiePoint(Point refLoc, int leftRight) {
        Point onScreen = this.comp.getLocationOnScreen();
        int x = onScreen.x - refLoc.x;
        if (leftRight > 0) {
            x += this.comp.getBounds().width;
        }
        int y = this.comp.getBounds().height / 2 + onScreen.y - refLoc.y;
        return new Point(x, y);
    }

    public void halfConnect(WireJack other) {
        while (this.connected.size() >= this.getMaxConnected() && this.connected.size() > 0) {
            WireJack wjack = (WireJack)this.connected.elementAt(this.connected.size() - 1);
            this.disconnect(wjack);
        }
        if (this.getMaxConnected() > 0) {
            this.connected.addElement(other);
        }
        this.module.halfConnect(this, other);
    }

    public void connect(WireJack other) {
        this.halfConnect(other);
        other.halfConnect(this);
    }

    public void halfDisconnect(WireJack other) {
        this.connected.removeElement(other);
        this.module.halfDisconnect(this, other);
    }

    public void disconnect(WireJack other) {
        this.halfDisconnect(other);
        other.halfDisconnect(this);
    }

    public void disconnectAll() {
        while (this.getConnectedCount() > 0) {
            WireJack connected = this.getConnected(0);
            this.disconnect(connected);
        }
    }

    void drawBentConnection(Graphics g, int x1, int y1, int x2, int y2) {
        int MIN_DX = 10;
        g.fillRect(x1, y1 - 4, 4, 8);
        g.fillRect(x2 - 4, y2 - 4, 4, 8);
        if (x1 + 20 < x2) {
            if (y1 == y2) {
                g.drawLine(x1, y1, x2, y2);
            } else {
                int xmid = (x1 + x2) / 2;
                g.drawLine(x1, y1, xmid, y1);
                g.drawLine(xmid, y1, xmid, y2);
                g.drawLine(xmid, y2, x2, y2);
            }
        } else {
            int ymid = (y1 + y2) / 2;
            g.drawLine(x1, y1, x1 + 10, y1);
            g.drawLine(x1 + 10, y1, x1 + 10, ymid);
            g.drawLine(x1 + 10, ymid, x2 - 10, ymid);
            g.drawLine(x2 - 10, ymid, x2 - 10, y2);
            g.drawLine(x2 - 10, y2, x2, y2);
        }
    }

    public void drawConnections(Graphics g, Point refLoc, boolean selected) {
        if (!this.isOutput()) {
            Color conColor = this.comp == null ? Wire.CONNECTOR_COLOR : this.comp.getBackground().darker();
            int i = 0;
            while (i < this.getConnectedCount()) {
                WireJack connected = this.getConnected(i);
                Point inPoint = this.getTiePoint(refLoc, 0);
                Point outPoint = connected.getTiePoint(refLoc, 1);
                if (selected || connected.getModule().getSelected()) {
                    g.setColor(Wire.CONNECTOR_COLOR);
                } else {
                    g.setColor(conColor);
                }
                if (Wire.drawStraightLines) {
                    g.drawLine(outPoint.x, outPoint.y, inPoint.x, inPoint.y);
                } else {
                    this.drawBentConnection(g, outPoint.x, outPoint.y, inPoint.x, inPoint.y);
                }
                ++i;
            }
        }
    }

    public void set(double value) {
        this.value = value;
    }

    void message(WireMessage msg) {
        this.set(msg.getValue());
        if (this.module.kicker == this) {
            this.module.kick(msg.getTimeStamp());
        }
    }

    public double get() {
        return this.value;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMax() {
        return this.max;
    }

    boolean edit() {
        if (this.dragged != null) {
            return this.dragged.edit();
        }
        return true;
    }

    void generateSource(IndentingWriter writer, int phase) throws IOException {
    }

    public void saveConnectionsToStream(Vector units, SaveAsStream stream) throws IOException {
        if (this.isOutput()) {
            int i = 0;
            while (i < this.getConnectedCount()) {
                WireJack wjack = this.getConnected(i);
                if (wjack == null) {
                    throw new WireException("Got NULL in " + this);
                }
                Module connectedModule = wjack.getModule();
                if (units.indexOf(connectedModule) >= 0) {
                    stream.writeConnection(this.getModule().getName(), this.getName(), this.getPartIndex(), connectedModule.getName(), wjack.getName(), wjack.getPartIndex());
                }
                ++i;
            }
        }
    }

    public void saveToStream(SaveAsStream stream) throws IOException {
    }
}

