/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.gui.patch.ModuleEditor;
import com.syntona.gui.patch.ModuleView;
import com.syntona.gui.patch.PatchFrame;
import com.syntona.model.SyntonaLoader;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.plugin.Jack;
import com.syntona.plugin.Loadable;
import com.syntona.plugin.Saveable;
import com.syntona.plugin.SyntonaModule;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ModulePresenter
implements Saveable,
Loadable {
    private SyntonaModule module;
    private ModuleView view;
    private PatchModulePresenter parent;
    private File file;
    private ModuleEditor moduleEditor;

    public ModulePresenter() {
    }

    public ModulePresenter(SyntonaModule module) {
        this.module = module;
    }

    public void setType(String type) {
        this.module.setType(type);
    }

    public SyntonaModule getModule() {
        return this.module;
    }

    public void setModule(SyntonaModule module) {
        this.module = module;
    }

    public ModuleView getView() {
        return this.view;
    }

    public void setView(ModuleView view) {
        if (view.getPresenter() == null) {
            view.setPresenter(this);
        }
        this.view = view;
    }

    public void delete() {
        this.hideMainEditor();
        if (this.parent != null) {
            this.getModule().disconnectAllJacks();
            this.getModule().removedFromPatch();
            this.parent.remove(this);
        }
    }

    public PatchFrame getParentPatchFrame() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getPatchFrame();
    }

    public void addedToPatch(PatchModulePresenter parent) {
        this.parent = parent;
        this.getModule().addedToPatch(parent.getPatchModule());
    }

    public ModuleEditor createModuleEditor() {
        return new ModuleEditor(this.view);
    }

    public Component showJackEditor() {
        if (this.moduleEditor == null || !this.moduleEditor.isVisible()) {
            this.moduleEditor = this.createModuleEditor();
            this.moduleEditor.show();
        }
        return this.moduleEditor.getComponent();
    }

    public void hideMainEditor() {
        if (this.moduleEditor != null) {
            this.moduleEditor.setVisible(false);
        }
    }

    public Component showMainEditor() {
        return this.showJackEditor();
    }

    @Override
    public void save(SyntonaSaver saver, boolean topLevel) throws ParserConfigurationException {
        saver.beginElement("module");
        this.module.saveAttributes(saver);
        if (this.view != null) {
            this.view.save(saver, topLevel);
        }
        this.saveContents(saver, topLevel);
        this.module.saveJacks(saver);
        saver.endElement();
    }

    public void saveContents(SyntonaSaver saver, boolean topLevel) throws ParserConfigurationException {
        this.module.saveContents(saver, topLevel);
    }

    public void loadJacks(Element moduleElement) {
        List<Element> nl = XMLDOMLoader.getChildrenByTagName(moduleElement, "jack");
        if (nl != null) {
            int i = 0;
            while (i < nl.size()) {
                Element jackElement = nl.get(i);
                String jackName = jackElement.getAttribute("name");
                Jack jack = this.getModule().getJackByName(jackName);
                if (jack != null) {
                    jack.loadContents(jackElement);
                } else {
                    System.err.println("Could not find jack " + jackName);
                }
                ++i;
            }
        }
    }

    public void onLoad() {
        this.module.onLoad();
    }

    public void loadContents(SyntonaLoader loader, Element moduleElement) throws ParserConfigurationException, SAXException, IOException {
        this.module.loadContents(loader, moduleElement);
        this.loadJacks(moduleElement);
    }

    public void markDirty() {
        if (this.parent != null) {
            this.parent.markDirty();
        }
    }

    public void markClean() {
    }

    public PatchModulePresenter getParent() {
        return this.parent;
    }

    public boolean saveIfDirty() throws ParserConfigurationException {
        return false;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean checkFileRecursion(File saveFile, int level) {
        return level > 0 && saveFile.equals(this.file);
    }
}

