/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.client;

import com.transjam.client.Client;
import com.transjam.client.ClientAdapter;
import com.transjam.util.Meeting;
import com.transjam.util.Schedule;
import java.io.IOException;
import java.util.Date;
import java.util.Observable;

public class MeetingSchedule
extends Observable {
    private Client client;
    private ClientAdapter clientAdapter;
    private Date serverDate;
    private Schedule schedule;

    public MeetingSchedule(Client pClient) {
        this.client = pClient;
        this.clientAdapter = new ClientAdapter(){

            @Override
            public void endedList() throws IOException {
                MeetingSchedule.this.notifyObservers();
            }

            @Override
            public void gotTime(Date when) throws IOException {
                MeetingSchedule.this.serverDate = when;
                MeetingSchedule.this.thisSetChanged();
            }

            @Override
            public void addedMeeting(Date when, int numClients) throws IOException {
                MeetingSchedule.this.addMeeting(when, numClients);
                MeetingSchedule.this.thisSetChanged();
            }
        };
    }

    public void thisSetChanged() {
        this.setChanged();
    }

    public void start() {
        this.stop();
        this.client.addMessageListener(this.clientAdapter, 1);
    }

    public void stop() {
        this.client.removeMessageListener(this.clientAdapter, 1);
    }

    public Date getServerDate() {
        return this.serverDate;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void joinMeeting(Date when) throws IOException {
        this.client.joinMeeting(when);
    }

    public void requestMeetingList() throws IOException {
        this.schedule = new Schedule();
        this.client.requestTime();
        this.client.requestMeetingList();
    }

    void addMeeting(Date when, int numClients) {
        Meeting meeting = this.schedule.addMeeting(when);
        meeting.setCount(numClients);
    }
}

