/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleWAV;
import com.transjam.drumbox.DrumBox;
import java.io.IOException;
import java.io.InputStream;

public abstract class SamplePlayerNote_16F1
extends SynthNote {
    SampleReader_16F1 s16f1rd;

    public SamplePlayerNote_16F1(String sampleName) {
        this(Synth.getSharedContext(), sampleName);
    }

    public SamplePlayerNote_16F1(SynthContext synthContext, String sampleName) {
        super(synthContext);
        if (this.getSample() == null) {
            this.loadSample(synthContext, sampleName);
        }
        this.s16f1rd = new SampleReader_16F1(synthContext);
        this.add(this.s16f1rd);
        this.output = this.s16f1rd.output;
        this.addPort(this.output, "output");
        this.amplitude = this.s16f1rd.amplitude;
        this.addPort(this.amplitude, "amplitude");
        this.amplitude.setup(0.0, 0.5, 1.0);
    }

    public void loadSample(SynthContext synthContext, String sampleName) {
        double rate = synthContext.getFrameRate();
        String rateString = rate < 30000.0 ? "22" : "44";
        String fileName = "samples/" + sampleName + rateString + "K.wav";
        try {
            InputStream stream = DrumBox.openFileOrURL(fileName);
            SynthSampleWAV sample = new SynthSampleWAV(synthContext, stream);
            stream.close();
            sample.setBaseFrequency(293.6656114469648);
            this.setSample(sample);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public abstract void setSample(SynthSample var1);

    public abstract SynthSample getSample();

    @Override
    public void setStage(int time, int stage) {
        SynthSample sample = this.getSample();
        if (sample == null) {
            return;
        }
        switch (stage) {
            case 0: {
                this.s16f1rd.samplePort.clear(time);
                this.s16f1rd.samplePort.queue(time, sample, 0, sample.getNumFrames(), 16);
                this.start(time);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    @Override
    public void delete() {
        super.delete();
        this.setSample(null);
    }
}

