/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.iptoxy;

import com.transjam.server.IPAddressToLocation;
import com.transjam.util.ClientLocation;
import com.transjam.util.DebugLog;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class IPLocatorMaxMind
implements IPAddressToLocation {
    Hashtable locationCache = new Hashtable(100);
    URL serviceURL;
    String licenseKey;
    private static final int MAX_IN_CACHE = 800;

    public IPLocatorMaxMind(String licenseKey) {
        this.licenseKey = licenseKey;
        try {
            this.serviceURL = new URL("http://maxmind.com:8010/b");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public IPLocatorMaxMind(URL serviceURL, String licenseKey) {
        this(licenseKey);
        this.serviceURL = serviceURL;
    }

    private String nextField(InputStream str) throws IOException {
        int c;
        StringBuffer buffer = new StringBuffer();
        while ((c = str.read()) >= 0 && c != 44) {
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    private ClientLocation readLocationFromWebService(InetAddress address) {
        ClientLocation location = null;
        try {
            String ipa = address.getHostAddress();
            String surl = String.valueOf(this.serviceURL.toString()) + "?l=" + this.licenseKey + "&i=" + ipa;
            URL url = new URL(surl);
            DebugLog.debugln(108, "URL = " + url);
            try {
                InputStream stream = url.openConnection().getInputStream();
                BufferedInputStream str = new BufferedInputStream(stream);
                ClientLocation loc = new ClientLocation();
                loc.country = this.nextField(str);
                loc.region = this.nextField(str);
                loc.city = this.nextField(str);
                try {
                    String s1 = this.nextField(str);
                    String s2 = this.nextField(str);
                    loc.latitude = Double.parseDouble(s1);
                    loc.longitude = Double.parseDouble(s2);
                    location = loc;
                    DebugLog.debugln(108, "IPLocatorMaxMind: IP = " + ipa + ", Location = " + location);
                }
                catch (NumberFormatException e1) {
                    String errMsg = this.nextField(str);
                    DebugLog.debugln(108, "IPLocatorMaxMind: " + errMsg + ", IP = " + ipa);
                }
                stream.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return location;
    }

    @Override
    public ClientLocation getLocation(InetAddress address) {
        ClientLocation location = (ClientLocation)this.locationCache.get(address);
        if (location == null && (location = this.readLocationFromWebService(address)) != null) {
            if (this.locationCache.size() >= 800) {
                Enumeration enumer = this.locationCache.keys();
                int limit = 20;
                while (enumer.hasMoreElements() && limit > 0) {
                    Object key = enumer.nextElement();
                    this.locationCache.remove(key);
                    --limit;
                }
            }
            this.locationCache.put(address, location);
        }
        return location;
    }
}

