/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthMixer;
import com.softsynth.jsyn.SynthNote;
import compmus.SineNote;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

public class BinaryBeeper
extends Applet
implements Runnable {
    static final double FUNDAMENTAL = 200.0;
    static final int NUM_BITS = 8;
    static final int BIT_MASK = 255;
    static final double PERIOD = 0.6;
    static final int FONT_SIZE = 48;
    SynthNote[] notes;
    SynthMixer mixer;
    LineOut lineOut;
    SynthEnvelope envelope;
    Thread thread;
    Button addButton;
    Button subtractButton;
    Checkbox autoBox;
    Label valueLabel;
    int value;
    volatile boolean go = false;
    boolean autoCount = false;

    public static void main(String[] args) {
        BinaryBeeper applet = new BinaryBeeper();
        AppletFrame frame = new AppletFrame("Binary Counter", applet);
        frame.resize(600, 320);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        try {
            Synth.startEngine(0);
            this.notes = new SynthNote[8];
            double[] data = new double[]{0.05, 1.0, 0.1, 0.8, 0.05, 0.0};
            this.envelope = new SynthEnvelope(data);
            this.lineOut = new LineOut();
            this.mixer = new SynthMixer(8, 1);
            this.mixer.connectOutput(0, this.lineOut.input, 0);
            this.mixer.connectOutput(0, this.lineOut.input, 1);
            int i = 0;
            while (i < 8) {
                System.out.println("Make note " + i);
                this.notes[i] = new SineNote(this.envelope);
                this.mixer.connectInput(i, this.notes[i].output, 0);
                this.mixer.setGain(i, 0, 0.125);
                ++i;
            }
            this.mixer.start();
            this.lineOut.start();
            this.setLayout(new GridLayout(0, 1));
            this.valueLabel = new Label();
            this.add(this.valueLabel);
            this.displayValue(0);
            this.valueLabel.setFont(new Font("Courier", 1, 48));
            Panel panel = new Panel();
            this.add(panel);
            this.addButton = new Button("+1");
            panel.add(this.addButton);
            this.subtractButton = new Button("-1");
            panel.add(this.subtractButton);
            this.autoBox = new Checkbox("Auto Count");
            panel.add(this.autoBox);
            this.getParent().validate();
            this.getToolkit().sync();
            this.thread = new Thread(this);
            this.go = true;
            this.thread.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.go = false;
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.out.println("Caught " + e);
        }
    }

    @Override
    public void run() {
        int duration = (int)(Synth.getTickRate() * 0.6);
        int time = Synth.getTickCount();
        boolean updateDisplay = false;
        try {
            while (this.go) {
                if (updateDisplay) {
                    this.displayValue(this.value);
                    updateDisplay = false;
                }
                if (this.autoCount) {
                    ++this.value;
                    this.playValue(time + duration, this.value);
                    updateDisplay = true;
                }
                Synth.sleepUntilTick(time += duration);
            }
        }
        catch (SynthException e) {
            System.out.println("run() caught " + e);
        }
    }

    void displayValue(int value) {
        String s = "";
        int i = 0;
        while (i < 8) {
            s = (value >> i & 1) == 0 ? "0" + s : "1" + s;
            ++i;
        }
        s = String.valueOf(s) + " = " + (value & 0xFF);
        this.valueLabel.setText(s);
    }

    void playValue(int time, int value) {
        int i = 0;
        while (i < 8) {
            if ((value >> i & 1) == 0) {
                this.notes[i].noteOff(time);
            } else {
                this.notes[i].noteOn(time, (double)(i + 1) * 200.0, 1.0);
            }
            ++i;
        }
    }

    void add(int incr) {
        this.value += incr;
        this.playValue(Synth.getTickCount(), this.value);
        this.displayValue(this.value);
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.addButton) {
            this.add(1);
            return true;
        }
        if (evt.target == this.subtractButton) {
            this.add(-1);
            return true;
        }
        if (evt.target == this.autoBox) {
            this.autoCount = this.autoBox.getState();
            return true;
        }
        return false;
    }
}

