/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view.PortFader;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import compmus.VariableCombFilter;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;

public abstract class DelayLab
extends Applet {
    LineOut lineOut;
    VariableCombFilter combFilter;
    SineOscillator sineOsc;

    @Override
    public void start() {
        this.setupEngine();
        this.setLayout(new GridLayout(0, 1));
        try {
            this.combFilter = new VariableCombFilter();
            this.sineOsc = new SineOscillator();
            this.lineOut = new LineOut();
            this.sineOsc.output.connect(this.combFilter.delayTimeModulator);
            this.combFilter.output.connect(0, this.lineOut.input, 0);
            this.combFilter.output.connect(0, this.lineOut.input, 1);
            this.sineOsc.start();
            this.combFilter.start();
            this.lineOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.add(new ExponentialPortFader(this.combFilter.delayTime, 0.5, 0.001, 1.0));
        this.add(new PortFader(this.combFilter.feedbackGain, 0.0, -1.0, 1.0));
        this.add(new PortFader(this.sineOsc.amplitude, "delayModDepth", 0.0, 0.0, 0.9));
        this.add(new ExponentialPortFader(this.sineOsc.frequency, "delayModRate", 0.3, 0.1, 20.0));
        this.add(new ExponentialPortFader(this.combFilter.dryMixGain, 0.001, 0.001, 1.0));
        this.add(new ExponentialPortFader(this.combFilter.wetMixGain, 0.5, 0.001, 1.0));
        this.setupSource();
        this.getParent().validate();
        this.getToolkit().sync();
    }

    public void setupEngine() {
        Synth.startEngine(0);
    }

    public abstract void setupSource();

    @Override
    public void stop() {
        this.removeAll();
        this.lineOut.delete();
        Synth.stopEngine();
    }
}

