/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.circuits.FilteredSawtoothBL;
import com.softsynth.jsyn.view102.CustomFader;
import com.softsynth.jsyn.view102.CustomFaderListener;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;

public class OctaveStretch
extends Applet
implements CustomFaderListener {
    FilteredSawtoothBL fsbl;
    LineOut myOut;
    CustomFader octaveFader;
    Button playButton;
    Button revealButton;
    Label octaveLabel;
    static final double baseFrequency = 400.0;
    double octave = 2.0;

    public static void main(String[] args) {
        OctaveStretch applet = new OctaveStretch();
        AppletFrame frame = new AppletFrame("Stretched Octave", applet);
        frame.resize(400, 250);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        try {
            Synth.startEngine(0);
            this.fsbl = new FilteredSawtoothBL();
            this.fsbl.resonance.set(0.5);
            this.myOut = new LineOut();
            this.fsbl.output.connect(0, this.myOut.input, 0);
            this.fsbl.output.connect(0, this.myOut.input, 1);
            this.myOut.start();
            this.octaveFader = new CustomFader(0, 0, 10, 0, 100);
            this.calculateOctave(0);
            this.octaveFader.addCustomFaderListener(this);
            this.octaveFader.setBlockIncrement(10);
            this.octaveFader.setUnitIncrement(1);
            this.setLayout(new GridLayout(0, 1));
            this.add(this.octaveFader);
            this.playButton = new Button("Play Stretched Octave");
            this.add(this.playButton);
            this.revealButton = new Button("Print Stretch");
            this.add(this.revealButton);
            this.octaveLabel = new Label("Stretch = ?????");
            this.add(this.octaveLabel);
            this.getParent().validate();
            this.getToolkit().sync();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.myOut.delete();
            this.fsbl.delete();
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            System.out.println("Caught " + e);
        }
    }

    void calculateOctave(int value) {
        this.octave = 2.0 + 0.05 * ((double)value - 25.0) / 100.0;
    }

    @Override
    public void customFaderValueChanged(Object fader, int value) {
        this.calculateOctave(value);
    }

    void revealAnswer() {
        double logStretch = Math.log(this.octave) / Math.log(2.0) - 1.0;
        int cents = (int)(1200.0 * logStretch + 0.5);
        this.octaveLabel.setText("Octave = " + this.octave + ", Stretch  = " + cents + " cents.");
    }

    void playOctave() {
        int time = Synth.getTickCount();
        int duration = (int)(Synth.getTickRate() * 0.8);
        this.fsbl.noteOn(time, 400.0, 0.5);
        this.fsbl.noteOff(time += duration);
        this.fsbl.noteOn(time += duration / 2, 400.0 * this.octave, 0.5);
        this.fsbl.noteOff(time += duration);
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.playButton) {
            this.playOctave();
            return true;
        }
        if (evt.target == this.revealButton) {
            this.revealAnswer();
            return true;
        }
        return false;
    }
}

