/*
 * Decompiled with CFR 0.152.
 */
package compmus;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleAIFF;
import com.softsynth.jsyn.SynthSampleWAV;
import com.softsynth.jsyn.SynthTable;
import compmus.ScrubberController;
import compmus.ScrubbingCircuit;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Label;
import java.awt.Panel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;

public class Scrubber
extends Applet {
    ScrubbingCircuit scrubCircuit;
    LineOut lineOut;
    Choice sampleChoices;
    ScrubberController xyCtrl;
    Label waitLabel;
    Button playButton;
    boolean isApplet = true;
    static final String FILENAME1 = "instructions.wav";
    static final String FILENAME2 = "instructions.wav";
    Hashtable namedTables;
    TDHolder currentHolder;

    public static void main(String[] args) {
        Scrubber applet = new Scrubber();
        AppletFrame frame = new AppletFrame("Play With It", applet);
        applet.isApplet = false;
        frame.resize(600, 460);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.namedTables = new Hashtable();
        try {
            Synth.startEngine(0);
            this.scrubCircuit = new ScrubbingCircuit();
            this.lineOut = new LineOut();
            this.scrubCircuit.output.connect(0, this.lineOut.input, 0);
            this.scrubCircuit.output.connect(0, this.lineOut.input, 1);
            this.scrubCircuit.start();
            this.lineOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.waitLabel = new Label("Please wait for sample to load.", 1);
        this.setLayout(new BorderLayout());
        this.xyCtrl = new ScrubberController(this.scrubCircuit);
        this.xyCtrl.setBackground(Color.yellow);
        this.add("Center", this.xyCtrl);
        Panel controlPanel = new Panel();
        this.add("South", controlPanel);
        this.sampleChoices = new Choice();
        controlPanel.add(this.sampleChoices);
        this.sampleChoices.add("instructions.wav");
        this.sampleChoices.add("instructions.wav");
        controlPanel.add(new Label("Click and drag mouse in box above.", 1));
        this.playButton = new Button("Play Sample");
        controlPanel.add(this.playButton);
        this.validate();
        this.useSampleName("instructions.wav");
        this.xyCtrl.start();
    }

    @Override
    public void stop() {
        this.xyCtrl.stop();
        this.removeAll();
        this.lineOut.delete();
        Synth.stopEngine();
    }

    public void useSampleName(String fileName) {
        TDHolder holder = (TDHolder)this.namedTables.get(fileName);
        if (holder == null) {
            this.sampleChoices.setEnabled(false);
            this.playButton.setEnabled(false);
            SLoader loader = new SLoader(fileName);
            loader.start();
        } else {
            this.useSample(holder);
        }
    }

    void useSample(TDHolder holder) {
        this.currentHolder = holder;
        this.xyCtrl.setData(holder.data);
        this.xyCtrl.repaint();
        this.scrubCircuit.tablePort.setTable(holder.table);
    }

    public TDHolder readHolderFromFile(String fileName) throws SynthException {
        TDHolder holder = null;
        double sampleRate = 44100.0;
        short[] shrtData = null;
        System.out.println("readHolderFromFile( " + fileName + ")");
        try {
            InputStream stream;
            if (this.isApplet) {
                System.out.println("CodeBase = " + this.getCodeBase());
                System.out.println("Path = " + this.getCodeBase());
                URL sampleURL = new URL(this.getCodeBase(), fileName);
                stream = sampleURL.openConnection().getInputStream();
            } else {
                File file = new File(fileName);
                System.out.println("file = " + file);
                System.out.println("cd = " + new File(".").getAbsolutePath());
                stream = new FileInputStream(file);
            }
            switch (SynthSample.getFileType(fileName)) {
                case 1: {
                    SynthSampleAIFF myAIFF = new SynthSampleAIFF();
                    shrtData = myAIFF.loadShorts(stream, true);
                    sampleRate = myAIFF.getSampleRate();
                    break;
                }
                case 2: {
                    SynthSampleWAV myWAV = new SynthSampleWAV();
                    shrtData = myWAV.loadShorts(stream, true);
                    sampleRate = myWAV.getSampleRate();
                    break;
                }
                default: {
                    SynthAlert.showError("Unrecognized sample file suffix.");
                }
            }
            SynthTable table = new SynthTable(shrtData.length);
            table.write(shrtData);
            holder = new TDHolder();
            holder.table = table;
            holder.data = shrtData;
            holder.duration = (double)shrtData.length / sampleRate;
            stream.close();
        }
        catch (IOException e) {
            SynthAlert.showError(e);
        }
        catch (SecurityException e) {
            SynthAlert.showError(e);
        }
        return holder;
    }

    @Override
    public boolean action(Event evt, Object arg) {
        if (evt.target == this.sampleChoices) {
            String fileName = this.sampleChoices.getSelectedItem();
            this.useSampleName(fileName);
        } else if (evt.target == this.playButton && this.currentHolder != null) {
            this.scrubCircuit.playSample(this.currentHolder.duration);
        }
        return super.action(evt, arg);
    }

    class SLoader
    extends Thread {
        String fileName;

        public SLoader(String pFileName) {
            this.fileName = pFileName;
        }

        @Override
        public void run() {
            Object table = null;
            Scrubber.this.remove(Scrubber.this.xyCtrl);
            Scrubber.this.add("Center", Scrubber.this.waitLabel);
            Scrubber.this.validate();
            TDHolder holder = Scrubber.this.readHolderFromFile("samples/" + this.fileName);
            if (holder != null) {
                Scrubber.this.namedTables.put(this.fileName, holder);
                Scrubber.this.useSample(holder);
            }
            Scrubber.this.remove(Scrubber.this.waitLabel);
            Scrubber.this.add("Center", Scrubber.this.xyCtrl);
            Scrubber.this.validate();
            Scrubber.this.sampleChoices.setEnabled(true);
            Scrubber.this.playButton.setEnabled(true);
        }
    }

    class TDHolder {
        SynthTable table;
        short[] data;
        double duration;

        TDHolder() {
        }
    }
}

