/*
 * Decompiled with CFR 0.152.
 */
package usertest;

import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.circuits.FilteredSawtoothBL;
import com.softsynth.jsyn.view102.SynthScope;
import com.softsynth.jsyn.view11x.SoundTester;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class FilteredSawVibrato
extends SynthNote {
    FilteredSawtoothBL circuit;
    public SynthInput cutoff;
    public SynthInput resonance;
    public SynthInput rate;

    public FilteredSawVibrato() {
        this(Synth.getSharedContext());
    }

    public FilteredSawVibrato(SynthContext synthContext) {
        super(synthContext);
        this.circuit = new FilteredSawtoothBL(synthContext);
        this.add(this.circuit);
        this.frequency = this.circuit.frequency;
        this.addPort(this.frequency, "frequency");
        this.amplitude = this.circuit.amplitude;
        this.addPort(this.amplitude, "amplitude");
        this.output = this.circuit.output;
        this.addPort(this.output, "output");
        this.cutoff = this.circuit.cutoff;
        this.addPort(this.cutoff, "cutoff");
        this.resonance = this.circuit.resonance;
        this.addPort(this.resonance, "resonance");
        this.rate = this.circuit.rate;
        this.addPort(this.rate, "rate");
    }

    @Override
    public void setStage(int time, int stage) {
        this.circuit.setStage(time, stage);
        switch (stage) {
            case 0: {
                this.start(time);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
        Synth.startEngine(0);
        LineOut out = new LineOut();
        out.start();
        FilteredSawVibrato sn = new FilteredSawVibrato();
        sn.output.connect(0, out.input, 0);
        sn.output.connect(0, out.input, 1);
        SynthScope scope = new SynthScope(Synth.getSharedContext(), 4096);
        scope.createProbe(sn.output, "SawOut", Color.yellow);
        scope.finish();
        Dialog scopeDialog = new Dialog(f, "JSyn Scope");
        scopeDialog.add("Center", scope);
        scopeDialog.setBounds(200, 200, 600, 500);
        scopeDialog.show();
        SoundTester tester = new SoundTester(sn);
        f.add(tester);
        f.pack();
        f.setVisible(true);
    }
}

