/*
 * Decompiled with CFR 0.152.
 */
package usertest;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;

public class TestNIC {
    public static void main(String[] args) {
        new TestNIC().test();
        System.exit(0);
    }

    private void test() {
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics != null && nics.hasMoreElements()) {
                NetworkInterface nic = nics.nextElement();
                System.out.println("--- " + nic.getDisplayName());
                System.out.println("  name = " + nic.getName());
                System.out.println("  virtual = " + nic.isVirtual());
                System.out.println("  up = " + nic.isUp());
                System.out.println("  multi = " + nic.supportsMulticast());
                System.out.println("  p2p = " + nic.isPointToPoint());
                List<InterfaceAddress> addresses = nic.getInterfaceAddresses();
                for (InterfaceAddress addr : addresses) {
                    System.out.println("  addr = " + addr);
                    InetAddress ipaddr = addr.getAddress();
                    System.out.println("       hostname = " + ipaddr.getHostName());
                    System.out.println("       reachable = " + ipaddr.isReachable(100));
                    System.out.println("       loopback = " + ipaddr.isLoopbackAddress());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

