/*
 * Decompiled with CFR 0.152.
 */
package usertest.nadia;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.Pan;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.VariableRateMonoReader;
import java.util.ArrayList;

public class ParticleSystem
extends Thread {
    LineOut lineOut;
    public Synthesizer synth = JSyn.createSynthesizer();
    ArrayList<SoundParticle> particles;

    public ParticleSystem() {
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.synth.start(10000);
        this.lineOut.start();
        this.particles = new ArrayList();
    }

    public void init() {
        this.setParticles(500);
        this.setParticles(2);
        this.setParticles(500);
        this.setParticles(2);
        this.setParticles(500);
        this.setParticles(2);
        this.setParticles(500);
        System.out.println("lastone");
        this.setParticles(8);
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setParticles(int numberOfParticles) {
        while (this.particles.size() < numberOfParticles) {
            Double freq = Math.random() * 10000.0;
            this.particles.add(new SoundParticle(this.synth, this.lineOut, freq));
        }
        while (this.particles.size() > numberOfParticles) {
            this.particles.get(0).stop();
            this.particles.remove(0);
        }
    }

    @Override
    public void run() {
        this.init();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.synth.stop();
    }

    private class SoundParticle {
        SineOscillator sineOsc;
        LineOut lineOut;
        Pan panorama;
        VariableRateMonoReader envPlayer;
        SegmentedEnvelope freqEnvelope;
        Synthesizer synth;

        SoundParticle(Synthesizer synthesizer, LineOut lo, Double frequence) {
            this.synth = synthesizer;
            this.lineOut = lo;
            this.sineOsc = new SineOscillator();
            this.synth.add(this.sineOsc);
            this.panorama = new Pan();
            this.synth.add(this.panorama);
            this.panorama.pan.set(0.0);
            this.sineOsc.output.connect(this.panorama.input);
            this.panorama.output.connect(0, this.lineOut.input, 0);
            this.panorama.output.connect(1, this.lineOut.input, 1);
            this.envPlayer = new VariableRateMonoReader();
            this.synth.add(this.envPlayer);
            this.envPlayer.output.connect(this.sineOsc.frequency);
            double[] data = new double[]{0.0, frequence};
            SegmentedEnvelope freqEnvelope = new SegmentedEnvelope(data);
            this.envPlayer.dataQueue.queueOn(freqEnvelope);
        }

        public void stop() {
            this.sineOsc.output.disconnectAll();
            this.envPlayer.output.disconnectAll();
            this.panorama.output.disconnectAll(0);
            this.panorama.output.disconnectAll(1);
            this.synth.remove(this.sineOsc);
            this.synth.remove(this.panorama);
            this.synth.remove(this.envPlayer);
        }
    }
}

