/*
 * Decompiled with CFR 0.152.
 */
package usertest.rossc;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.Filter_LowPass;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SawtoothOscillator;
import com.softsynth.jsyn.SynthEnvelope;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

class MovingGraphicsScreenJSyn
extends JPanel
implements Runnable {
    private int size = 1;
    private SawtoothOscillator Saw1;
    private SawtoothOscillator Saw2;
    private AddUnit Mixer;
    private Filter_LowPass FLP;
    private EnvelopePlayer EP;
    private SynthEnvelope ShortEnv;
    private LineOut LO;

    public MovingGraphicsScreenJSyn() {
        Thread T = new Thread(this);
        T.start();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                MovingGraphicsScreenJSyn.this.mouseDown();
            }
        });
        this.Saw1 = new SawtoothOscillator();
        this.Saw1.frequency.set(55.0);
        this.Saw2 = new SawtoothOscillator();
        this.Saw2.frequency.set(54.75);
        this.Mixer = new AddUnit();
        this.Saw1.output.connect(this.Mixer.inputA);
        this.Saw2.output.connect(this.Mixer.inputB);
        this.FLP = new Filter_LowPass();
        this.Mixer.output.connect(this.FLP.input);
        this.FLP.Q.set(4.0);
        LineOut LO = new LineOut();
        this.FLP.output.connect(0, LO.input, 0);
        this.FLP.output.connect(0, LO.input, 1);
        this.EP = new EnvelopePlayer();
        this.EP.output.connect(this.FLP.frequency);
        double[] data = new double[]{0.1, 5000.0, 4.0, 500.0};
        this.ShortEnv = new SynthEnvelope(data);
        this.Saw1.start();
        this.Saw2.start();
        this.Mixer.start();
        this.FLP.start();
        LO.start();
        this.EP.start();
        this.EP.envelopePort.queue(this.ShortEnv);
    }

    private void mouseDown() {
        this.size = 1;
        this.EP.envelopePort.clear();
        this.EP.envelopePort.queue(this.ShortEnv);
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension Size = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, Size.width, Size.height);
        g.setColor(Color.white);
        int middleX = Size.width / 2;
        int middleY = Size.height / 2;
        g.drawRect(middleX - this.size / 2, middleY - this.size / 2, this.size, this.size);
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            ++this.size;
            this.repaint();
        }
    }
}

