/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthSample;
import java.applet.Applet;
import java.awt.Button;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class TJ_CheckMem
extends Applet {
    Label versionLabel;
    Label freeMemoryLabel;
    Label totalMemoryLabel;
    Label bytesJavaLabel;
    Label bytesNativeLabel;
    Label errorLabel;
    Button memJavaButton;
    Button memNativeButton;
    Vector arrays;
    Vector samples;
    TextField textField;
    static final int BLOCK_SIZE = 500000;
    int bytesJava;
    int bytesNative;

    public static void main(String[] args) {
        TJ_CheckMem applet = new TJ_CheckMem();
        AppletFrame frame = new AppletFrame("Test Java Memory", applet);
        frame.resize(600, 500);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        this.arrays = new Vector();
        this.samples = new Vector();
        Synth.startEngine(0);
        this.versionLabel = new Label("Version = ");
        this.add(this.versionLabel);
        this.freeMemoryLabel = new Label("");
        this.add(this.freeMemoryLabel);
        this.totalMemoryLabel = new Label("");
        this.add(this.totalMemoryLabel);
        this.bytesJavaLabel = new Label("");
        this.add(this.bytesJavaLabel);
        this.bytesNativeLabel = new Label("");
        this.add(this.bytesNativeLabel);
        this.errorLabel = new Label("Exception = ");
        this.add(this.errorLabel);
        this.memJavaButton = new Button("Allocate Java Memory");
        this.add(this.memJavaButton);
        this.memJavaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TJ_CheckMem.this.allocJava();
            }
        });
        this.memNativeButton = new Button("Allocate Native Memory");
        this.add(this.memNativeButton);
        this.memNativeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TJ_CheckMem.this.allocNative();
            }
        });
        this.showMem();
        this.getParent().validate();
        this.getToolkit().sync();
    }

    void showMem() {
        int version = Synth.getVersion();
        this.versionLabel.setText("Version = " + version);
        Runtime.getRuntime().gc();
        this.freeMemoryLabel.setText("Free = " + Runtime.getRuntime().freeMemory());
        this.totalMemoryLabel.setText("Total = " + Runtime.getRuntime().totalMemory());
        this.bytesJavaLabel.setText("Java Allocated = " + this.bytesJava);
        this.bytesNativeLabel.setText("Native Allocated = " + this.bytesNative);
    }

    void allocJava() {
        try {
            byte[] bytes = new byte[500000];
            this.bytesJava += 500000;
            this.arrays.addElement(bytes);
        }
        catch (Exception e) {
            this.errorLabel.setText("Exception = " + e);
        }
        this.showMem();
    }

    void allocNative() {
        try {
            int numSamples = 250000;
            SynthSample sam = new SynthSample(numSamples);
            this.bytesNative += 500000;
            this.samples.addElement(sam);
        }
        catch (Exception e) {
            this.errorLabel.setText("Exception = " + e);
        }
        this.showMem();
    }

    @Override
    public void stop() {
        this.removeAll();
        Synth.stopEngine();
    }
}

