/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.view102.PortFader;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;

public class TJ_SampleWR
extends Applet {
    SynthSample mySamp;
    SampleReader_16V1 mySampler;
    LineOut myOut;
    static final int NUM_FRAMES = 22000;
    Checkbox toggle;
    Button readButton;
    short[] data;

    public static void main(String[] args) {
        TJ_SampleWR applet = new TJ_SampleWR();
        AppletFrame frame = new AppletFrame("Test SynthSample R/W", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            this.data = new short[22000];
            double phase = 0.17;
            double phaseIncr = 0.001;
            int i = 0;
            while (i < 22000) {
                this.data[i] = (short)(Math.sin(phase * (Math.PI * 2)) * 32767.0);
                phase += phaseIncr;
                while (phase > 1.0) {
                    phase -= 1.0;
                }
                if ((phaseIncr *= 1.0001) > 0.25) {
                    phaseIncr = 0.25;
                }
                ++i;
            }
            this.mySamp = new SynthSample(22000);
            this.mySamp.write(this.data);
            i = 0;
            while (i < 10) {
                System.out.println("data[" + i + "] = " + this.data[i]);
                ++i;
            }
            this.mySampler = new SampleReader_16V1();
            this.myOut = new LineOut();
            this.mySampler.samplePort.queueLoop(this.mySamp, 0, 22000);
            this.mySampler.output.connect(0, this.myOut.input, 0);
            this.mySampler.output.connect(0, this.myOut.input, 1);
            this.toggle = new Checkbox("Toggle");
            this.add(this.toggle);
            this.readButton = new Button("Read");
            this.add(this.readButton);
            this.add(new PortFader(this.mySampler.amplitude, 0.7, 0.0, 1.0));
            this.add(new PortFader(this.mySampler.rate, 44100.0, 0.0, 88200.0));
            this.myOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.mySampler.delete();
            this.mySampler = null;
            this.myOut.delete();
            this.myOut = null;
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        if (evt.target == this.toggle) {
            if (this.toggle.getState()) {
                this.mySampler.start();
                return true;
            }
            this.mySampler.stop();
            return true;
        }
        if (evt.target == this.readButton) {
            System.out.println("Create data array.");
            int i = 0;
            while (i < 5) {
                this.data[i] = (short)(1000 + i);
                ++i;
            }
            this.mySamp.read(0, this.data, 0, 22000);
            System.out.println("Read " + this.data.length + " short.");
            i = 0;
            while (i < 10) {
                System.out.println("data[" + i + "] = " + this.data[i]);
                ++i;
            }
        }
        return false;
    }
}

