/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16F2;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleAIFF;
import com.softsynth.jsyn.SynthSampleWAV;
import com.softsynth.jsyn.view102.PortFader;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class TestLeftRight
extends Applet {
    SynthSample mySamp;
    SampleReader_16F2 mySampler;
    LineOut myOut;
    Button hitButton;
    Button onButton;
    Button offButton;
    Label progressLabel;
    public String fileName = null;

    public static void main(String[] args) {
        TestLeftRight applet = new TestLeftRight();
        if (args.length > 0) {
            applet.fileName = args[0];
        }
        AppletFrame frame = new AppletFrame("Test SynthSample", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            Synth.verbosity = 0;
            if (this.fileName == null) {
                this.fileName = "samples/LeftRight.aiff";
            }
            try {
                FileInputStream stream = new FileInputStream(this.fileName);
                try {
                    switch (SynthSample.getFileType(this.fileName)) {
                        case 1: {
                            this.mySamp = new SynthSampleAIFF(stream);
                            break;
                        }
                        case 2: {
                            this.mySamp = new SynthSampleWAV(stream);
                            break;
                        }
                        default: {
                            SynthAlert.showError((Component)this, "Unrecognized sample file suffix.");
                        }
                    }
                    System.out.println(this.mySamp.dump());
                    stream.close();
                }
                catch (IOException e) {
                    SynthAlert.showError((Component)this, e);
                }
            }
            catch (FileNotFoundException e) {
                SynthAlert.showError((Component)this, e);
            }
            catch (SecurityException e) {
                SynthAlert.showError((Component)this, e);
            }
            this.mySampler = new SampleReader_16F2();
            this.myOut = new LineOut();
            this.mySampler.output.connect(0, this.myOut.input, 0);
            this.mySampler.output.connect(1, this.myOut.input, 1);
            this.hitButton = new Button("Hit");
            this.add(this.hitButton);
            this.onButton = new Button("On");
            this.add(this.onButton);
            this.offButton = new Button("Off");
            this.add(this.offButton);
            this.progressLabel = new Label("Frames = ");
            this.add(this.progressLabel);
            this.add(new PortFader(this.mySampler.amplitude, 0.7, 0.0, 1.0));
            this.myOut.start();
            this.mySampler.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.mySampler.delete();
            this.mySampler = null;
            this.myOut.delete();
            this.myOut = null;
            this.removeAll();
            Synth.verbosity = 0;
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    void showFramesMoved() {
        this.progressLabel.setText("Frames = " + this.mySampler.samplePort.getNumFramesMoved());
    }

    @Override
    public boolean action(Event evt, Object what) {
        block6: {
            block5: {
                try {
                    if (evt.target != this.hitButton) break block5;
                    this.mySampler.samplePort.queue(this.mySamp);
                    this.showFramesMoved();
                    return true;
                }
                catch (SynthException e) {
                    SynthAlert.showError((Component)this, e);
                    return true;
                }
            }
            if (evt.target != this.onButton) break block6;
            this.mySampler.samplePort.queueOn(this.mySamp);
            this.showFramesMoved();
            return true;
        }
        if (evt.target == this.offButton) {
            this.mySampler.samplePort.queueOff(this.mySamp);
            this.showFramesMoved();
            return true;
        }
        return false;
    }
}

