/*
 * Decompiled with CFR 0.152.
 */
package berliner;

import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.SynthSampleAIFF;
import com.softsynth.jsyn.SynthSampleWAV;
import com.softsynth.jsyn.SynthTable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SynthTableFromFile
extends SynthTable {
    public SynthTableFromFile(String fileName) throws SynthException {
        short[] shrtData = null;
        try {
            try {
                FileInputStream stream = new FileInputStream(fileName);
                try {
                    switch (SynthSample.getFileType(fileName)) {
                        case 1: {
                            SynthSampleAIFF myAIFF = new SynthSampleAIFF();
                            shrtData = myAIFF.loadShorts(stream, true);
                            break;
                        }
                        case 2: {
                            SynthSampleWAV myWAV = new SynthSampleWAV();
                            shrtData = myWAV.loadShorts(stream, true);
                            break;
                        }
                        default: {
                            SynthAlert.showError("Unrecognized sample file suffix.");
                        }
                    }
                    stream.close();
                }
                catch (IOException e) {
                    SynthAlert.showError(e);
                }
            }
            catch (FileNotFoundException e) {
                SynthAlert.showError(e);
            }
            catch (SecurityException e) {
                SynthAlert.showError(e);
            }
            if (shrtData != null) {
                this.allocate(shrtData.length);
                this.write(shrtData);
            }
        }
        catch (Exception e) {
            SynthAlert.showError("Error in SynthTableFromFile = " + e);
        }
    }
}

