/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.examples.WindCircuit;
import com.jsyn.scope.AudioScope;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.SoundTweaker;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.UnitSource;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JApplet;

public class CircuitTester
extends JApplet {
    private static final long serialVersionUID = -2704222221111608377L;
    private Synthesizer synth;
    private LineOut lineOut;
    private SoundTweaker tweaker;
    private UnitSource unitSource;
    private AudioScope scope;

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.unitSource = this.createUnitSource();
        this.synth.add(this.unitSource.getUnitGenerator());
        this.unitSource.getOutput().connect(0, this.lineOut.input, 0);
        this.unitSource.getOutput().connect(0, this.lineOut.input, 1);
        this.tweaker = new SoundTweaker(this.synth, this.unitSource.getUnitGenerator().getClass().getName(), this.unitSource);
        this.add((Component)this.tweaker, "Center");
        this.scope = new AudioScope(this.synth);
        this.scope.addProbe(this.unitSource.getOutput());
        this.scope.setTriggerMode(AudioScope.TriggerMode.NORMAL);
        this.scope.getView().setControlsVisible(false);
        this.add("South", this.scope.getView());
        this.validate();
    }

    public UnitSource createUnitSource() {
        return new WindCircuit();
    }

    @Override
    public void start() {
        this.synth.start();
        this.lineOut.start();
        this.scope.start();
    }

    @Override
    public void stop() {
        this.scope.stop();
        this.synth.stop();
    }

    public static void main(String[] args) {
        CircuitTester applet = new CircuitTester();
        JAppletFrame frame = new JAppletFrame("JSyn Circuit Tester", applet);
        frame.setSize(600, 600);
        frame.setVisible(true);
        frame.test();
    }
}

