/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.unitgen.ExponentialRamp;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.util.WaveRecorder;
import java.io.File;
import java.io.IOException;

public class RecordSineSweep {
    static final double SONG_DURATION = 4.0;
    private Synthesizer synth;
    private UnitOscillator leftOsc;
    private UnitOscillator rightOsc;
    private ExponentialRamp sweeper;
    private LineOut lineOut;
    private WaveRecorder recorder;
    private static final boolean useRecorder = true;

    private void test() throws IOException {
        this.synth = JSyn.createSynthesizer();
        this.synth.setRealTime(false);
        File waveFile = new File("temp_recording.wav");
        this.recorder = new WaveRecorder(this.synth, waveFile);
        System.out.println("Writing to WAV file " + waveFile.getAbsolutePath());
        this.leftOsc = new SineOscillator();
        this.synth.add(this.leftOsc);
        this.rightOsc = new SawtoothOscillatorBL();
        this.synth.add(this.rightOsc);
        this.sweeper = new ExponentialRamp();
        this.synth.add(this.sweeper);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.sweeper.current.set(50.0);
        this.sweeper.input.set(1400.0);
        this.sweeper.time.set(4.0);
        this.sweeper.output.connect(this.leftOsc.frequency);
        this.sweeper.output.connect(this.rightOsc.frequency);
        this.leftOsc.output.connect(0, this.lineOut.input, 0);
        this.rightOsc.output.connect(0, this.lineOut.input, 1);
        this.synth.start();
        this.leftOsc.output.connect(0, this.recorder.getInput(), 0);
        this.rightOsc.output.connect(0, this.recorder.getInput(), 1);
        this.recorder.start();
        this.lineOut.start();
        double timeNow = this.synth.getCurrentTime();
        try {
            this.synth.sleepUntil(timeNow + 4.0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.recorder != null) {
            System.out.println("Stop and restart recorder.");
            this.recorder.stop();
        }
        this.sweeper.input.set(100.0);
        timeNow = this.synth.getCurrentTime();
        if (this.recorder != null) {
            this.recorder.start();
        }
        try {
            this.synth.sleepUntil(timeNow + 4.0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.recorder != null) {
            this.recorder.stop();
            this.recorder.close();
        }
        this.synth.stop();
    }

    public static void main(String[] args) {
        try {
            new RecordSineSweep().test();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

