/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.pieces.improv;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.SubtractiveSynthVoice;
import com.jsyn.pieces.improv.Jammer;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.VoiceAllocator;
import java.awt.BorderLayout;
import javax.swing.JApplet;

public class JamApp
extends JApplet {
    private static final long serialVersionUID = -7459137388629333223L;
    private Synthesizer synth;
    private Add mixer;
    private LineOut lineOut;
    private static final int MAX_VOICES = 8;
    private Jammer[] jammers = new Jammer[2];

    public static void main(String[] args) {
        JamApp applet = new JamApp();
        JAppletFrame frame = new JAppletFrame("JamApp", applet);
        frame.setSize(640, 300);
        frame.setVisible(true);
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        this.synth = JSyn.createSynthesizer();
        this.mixer = new Add();
        this.synth.add(this.mixer);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.mixer.output.connect(0, this.lineOut.input, 0);
        this.mixer.output.connect(0, this.lineOut.input, 1);
        UnitVoice[] voices = new SubtractiveSynthVoice[8];
        int i = 0;
        while (i < 8) {
            SubtractiveSynthVoice voice = new SubtractiveSynthVoice();
            this.synth.add(voice);
            voice.getOutput().connect(this.mixer.inputA);
            voices[i] = voice;
            ++i;
        }
        VoiceAllocator allocator = new VoiceAllocator(voices);
        this.jammers[0] = new Jammer("A", this.synth, allocator);
        this.jammers[1] = new Jammer("B", this.synth, allocator);
        this.synth.start();
        this.lineOut.start();
        this.getParent().validate();
        this.getToolkit().sync();
        Jammer[] jammerArray = this.jammers;
        int n = this.jammers.length;
        int n2 = 0;
        while (n2 < n) {
            Jammer jammer = jammerArray[n2];
            jammer.start();
            ++n2;
        }
    }

    @Override
    public void stop() {
        Jammer[] jammerArray = this.jammers;
        int n = this.jammers.length;
        int n2 = 0;
        while (n2 < n) {
            Jammer jammer = jammerArray[n2];
            jammer.stop();
            ++n2;
        }
        this.removeAll();
        this.synth.stop();
    }
}

