/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.TunableFilter;

public class FilterFourPoles
extends TunableFilter {
    public UnitInputPort Q = new UnitInputPort("Q");
    public UnitInputPort gain;
    private static final double MINIMUM_FREQUENCY = 1.0E-5;
    private static final double MINIMUM_Q = 1.0E-5;
    private double x1;
    private double x2;
    private double x3;
    private double x4;
    private double y1;
    private double y2;
    private double y3;
    private double y4;
    private double previousFrequency;
    private double previousQ;
    private double f;
    private double fTo4th;
    private double feedback;
    private boolean oversampled = true;

    public FilterFourPoles() {
        this.addPort(this.Q);
        this.Q.setup(0.1, 2.0, 10.0);
    }

    public void recalculate() {
        double frequencyValue = this.frequency.getValues()[0];
        double qValue = this.Q.getValues()[0];
        if (frequencyValue < 1.0E-5) {
            frequencyValue = 1.0E-5;
        }
        if (qValue < 1.0E-5) {
            qValue = 1.0E-5;
        }
        if (frequencyValue != this.previousFrequency || qValue != this.previousQ) {
            this.previousFrequency = frequencyValue;
            this.previousQ = qValue;
            this.computeCoefficients();
        }
    }

    private void computeCoefficients() {
        double normalizedFrequency = this.previousFrequency * this.getFramePeriod();
        double fudge = 4.9 - 0.27 * this.previousQ;
        if (fudge < 3.0) {
            fudge = 3.0;
        }
        this.f = normalizedFrequency * (this.oversampled ? 1.0 : 2.0) * fudge;
        double fSquared = this.f * this.f;
        this.fTo4th = fSquared * fSquared;
        this.feedback = 0.5 * this.previousQ * (1.0 - 0.15 * fSquared);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] outputs = this.output.getValues();
        this.recalculate();
        int i = start;
        while (i < limit) {
            double x0 = inputs[i];
            if (this.oversampled) {
                this.oneSample(0.0);
            }
            this.oneSample(x0);
            outputs[i] = this.y4;
            ++i;
        }
        this.y1 += 1.0E-26;
        this.y2 -= 1.0E-26;
    }

    private void oneSample(double x0) {
        double coeff = 0.3;
        x0 -= this.y4 * this.feedback;
        this.y1 = (x0 *= 0.35013 * this.fTo4th) + 0.3 * this.x1 + (1.0 - this.f) * this.y1;
        this.x1 = x0;
        this.y2 = this.y1 + 0.3 * this.x2 + (1.0 - this.f) * this.y2;
        this.x2 = this.y1;
        this.y3 = this.y2 + 0.3 * this.x3 + (1.0 - this.f) * this.y3;
        this.x3 = this.y2;
        this.y4 = this.y3 + 0.3 * this.x4 + (1.0 - this.f) * this.y4;
        this.y4 = this.clip(this.y4);
        this.x4 = this.y3;
    }

    public boolean isOversampled() {
        return this.oversampled;
    }

    public void setOversampled(boolean oversampled) {
        this.oversampled = oversampled;
    }

    private double clip(double x) {
        return x - x * x * x * 0.1666667;
    }
}

