/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.PinkNoise;
import com.jsyn.unitgen.PitchDetector;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.SineOscillator;
import com.jsynx.inprogress.PeriodAnalyzerFeatureBased;
import junit.framework.TestCase;

public class TestPeriodAnalyzer
extends TestCase {
    Synthesizer synth;
    double[] fundamentals = new double[]{123.0, 567.0, 2345.0};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.synth = JSyn.createSynthesizer();
        this.synth.setRealTime(false);
        this.synth.start();
    }

    @Override
    protected void tearDown() throws Exception {
        this.synth.stop();
    }

    private void checkAnalysis(double freq, UnitOutputPort source, Class<?> periodClass) throws InterruptedException, InstantiationException, IllegalAccessException {
        PitchDetector analyzer = (PitchDetector)periodClass.newInstance();
        this.synth.add(analyzer);
        source.connect(analyzer.input);
        analyzer.start();
        long startAt = System.currentTimeMillis();
        this.synth.sleepFor(1.0);
        long endAt = System.currentTimeMillis();
        System.out.println("---- Analyzer = " + periodClass.getSimpleName());
        System.out.println("Freq = " + freq + ", ran at " + (double)(endAt - startAt) / 10.0 + "% of realtime.");
        double expectedPeriod = (double)this.synth.getFrameRate() / freq;
        double measuredPeriod = analyzer.period.getValue();
        System.out.println("expectedPeriod = " + expectedPeriod + ", measuredPeriod = " + measuredPeriod);
        TestPeriodAnalyzer.assertEquals("Sawtooth period", expectedPeriod, measuredPeriod, expectedPeriod * 0.05);
        analyzer.stop();
        source.disconnect(analyzer.input);
    }

    private void checkAnalysis(double freq, UnitOutputPort source) throws InterruptedException, InstantiationException, IllegalAccessException {
        this.checkAnalysis(freq, source, PitchDetector.class);
        this.checkAnalysis(freq, source, PeriodAnalyzerFeatureBased.class);
    }

    private void checkSawtooth(double freq) throws InterruptedException, InstantiationException, IllegalAccessException {
        SawtoothOscillatorBL osc = new SawtoothOscillatorBL();
        this.synth.add(osc);
        osc.frequency.set(freq);
        this.checkAnalysis(freq, osc.output);
    }

    public void testSawtooth1() throws InterruptedException, InstantiationException, IllegalAccessException {
        System.out.println("sawtooth1==============");
        double[] dArray = this.fundamentals;
        int n = this.fundamentals.length;
        int n2 = 0;
        while (n2 < n) {
            double freq = dArray[n2];
            this.checkSawtooth(freq);
            ++n2;
        }
    }

    public void testSawtooth() throws InterruptedException, InstantiationException, IllegalAccessException {
        System.out.println("sawtooth ==============");
        double[] dArray = this.fundamentals;
        int n = this.fundamentals.length;
        int n2 = 0;
        while (n2 < n) {
            double freq = dArray[n2];
            this.checkSawtooth(freq);
            ++n2;
        }
    }

    private void checkComplexWave(double freq, double[] partials) throws InterruptedException, InstantiationException, IllegalAccessException {
        PassThrough mixer = this.createComplexOscillator(freq, partials);
        this.checkAnalysis(freq, mixer.output);
    }

    private PassThrough createComplexOscillator(double freq, double[] partials) {
        PassThrough mixer = new PassThrough();
        this.synth.add(mixer);
        double[] dArray = partials;
        int n = partials.length;
        int n2 = 0;
        while (n2 < n) {
            double ampl = dArray[n2];
            SineOscillator osc = new SineOscillator(freq);
            this.synth.add(osc);
            osc.amplitude.set(ampl);
            osc.output.connect(mixer.input);
            ++n2;
        }
        return mixer;
    }

    public void testComplexWave() throws InterruptedException, InstantiationException, IllegalAccessException {
        System.out.println("complex wave ==============");
        double[] partials = new double[]{0.5, 0.5, 0.2, 0.1, 0.1};
        double[] dArray = this.fundamentals;
        int n = this.fundamentals.length;
        int n2 = 0;
        while (n2 < n) {
            double freq = dArray[n2];
            this.checkComplexWave(freq, partials);
            ++n2;
        }
    }

    private void checkNoisyWave(double freq, double[] partials) throws InterruptedException, InstantiationException, IllegalAccessException {
        PassThrough mixer = this.createComplexOscillator(freq, partials);
        PinkNoise noise = new PinkNoise();
        this.synth.add(noise);
        noise.amplitude.set(1.0);
        noise.output.connect(mixer.input);
        this.checkAnalysis(freq, mixer.output);
    }

    public void testNoisyWave() throws InterruptedException, InstantiationException, IllegalAccessException {
        System.out.println("noisy wave ==============");
        double[] partials = new double[]{0.5, 0.5, 0.2, 0.1, 0.1};
        double[] dArray = this.fundamentals;
        int n = this.fundamentals.length;
        int n2 = 0;
        while (n2 < n) {
            double freq = dArray[n2];
            this.checkNoisyWave(freq, partials);
            ++n2;
        }
    }
}

