/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitVoice;
import com.softsynth.shared.time.TimeStamp;

public abstract class UnitOscillator
extends UnitGenerator
implements UnitVoice {
    public UnitInputPort frequency = new UnitInputPort("Frequency");
    public UnitInputPort amplitude;
    public UnitVariablePort phase;
    public UnitOutputPort output;
    public static final double DEFAULT_FREQUENCY = 440.0;
    public static final double DEFAULT_AMPLITUDE = 0.999969482421875;

    public UnitOscillator() {
        this.addPort(this.frequency);
        this.frequency.setup(40.0, 440.0, 8000.0);
        this.amplitude = new UnitInputPort("Amplitude", 0.999969482421875);
        this.addPort(this.amplitude);
        this.phase = new UnitVariablePort("Phase");
        this.addPort(this.phase);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
    }

    public double convertFrequencyToPhaseIncrement(double freq) {
        double phaseIncrement;
        try {
            phaseIncrement = freq * this.synthesisEngine.getInverseNyquist();
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Null Synth! You probably forgot to add this unit to the Synthesizer!");
        }
        phaseIncrement = phaseIncrement > 1.0 ? 1.0 : (phaseIncrement < -1.0 ? -1.0 : phaseIncrement);
        return phaseIncrement;
    }

    @Override
    public UnitOutputPort getOutput() {
        return this.output;
    }

    public void noteOn(double freq, double ampl) {
        this.frequency.set(freq);
        this.amplitude.set(ampl);
    }

    public void noteOff() {
        this.amplitude.set(0.0);
    }

    @Override
    public void noteOff(TimeStamp timeStamp) {
        this.amplitude.set(0.0, timeStamp);
    }

    @Override
    public void noteOn(double freq, double ampl, TimeStamp timeStamp) {
        this.frequency.set(freq, timeStamp);
        this.amplitude.set(ampl, timeStamp);
    }

    @Override
    public void usePreset(int presetIndex) {
    }
}

