/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import java.util.Random;

public class PseudoRandom {
    private static final double INT_TO_DOUBLE = 4.656612873077393E-10;
    private long seed = 99887766L;

    public PseudoRandom() {
        this(new Random().nextInt());
    }

    public PseudoRandom(int seed) {
        this.setSeed(seed);
    }

    public void setSeed(int seed) {
        this.seed = (long)seed & 0xFFFFFFFFFFFFFFFFL;
    }

    public int getSeed() {
        return (int)this.seed;
    }

    public double random() {
        int positiveInt = this.nextRandomInteger() & Integer.MAX_VALUE;
        return (double)positiveInt * 4.656612873077393E-10;
    }

    public double nextRandomDouble() {
        return (double)this.nextRandomInteger() * 4.656612873077393E-10;
    }

    public int nextRandomInteger() {
        long rand = this.seed * 196314165L + 907633515L;
        this.seed = rand & 0xFFFFFFFFL;
        return (int)rand;
    }

    public int choose(int range) {
        long bigRandom = this.nextRandomInteger() & Integer.MAX_VALUE;
        long temp = bigRandom * (long)range;
        return (int)(temp >> 31);
    }
}

