/*
 * Decompiled with CFR 0.152.
 */
package com.jsynx.inprogress;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.FloatSample;
import com.jsyn.midi.MidiConstants;
import com.jsyn.scope.AudioScope;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.unitgen.ChannelIn;
import com.jsyn.unitgen.FilterHighPass;
import com.jsyn.unitgen.FilterLowPass;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.PeakFollower;
import com.jsyn.unitgen.PitchDetector;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.util.AudioStreamReader;
import com.jsyn.util.WaveRecorder;
import com.jsynx.inprogress.ScrollingEdgeDisplay;
import com.jsynx.inprogress.SequentialDataView;
import com.jsynx.inprogress.SlidingPitchDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TunerApplet
extends JApplet {
    private static final long serialVersionUID = -2704222221111608377L;
    private Synthesizer synth;
    private UnitOscillator osc;
    private ChannelIn channelIn;
    private AudioScope scope;
    private LineOut lineOut;
    private PitchDetector pitchDetector;
    private SequentialDataView view;
    private Timer diffTimer;
    private WaveRecorder recorder;
    private PeakFollower peakFollower;
    private Multiply peakScaler;
    private SlidingPitchDisplay slidingPitchDisplay;
    private FilterLowPass lowPass;
    private FilterHighPass highPass;
    private JLabel cpuLabel;
    private JLabel pitchLabel;
    private JLabel freqLabel;
    private JLabel confidenceLabel;
    private ScrollingEdgeDisplay spectrogram;
    private Timer spectrumTimer;
    private AudioStreamReader reader;
    private static final boolean useRecorder = false;

    @Override
    public void init() {
        this.synth = JSyn.createSynthesizer();
        this.channelIn = new ChannelIn();
        this.synth.add(this.channelIn);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.pitchDetector = new PitchDetector();
        this.synth.add(this.pitchDetector);
        this.highPass = new FilterHighPass();
        this.synth.add(this.highPass);
        this.highPass.frequency.set(50.0);
        this.lowPass = new FilterLowPass();
        this.synth.add(this.lowPass);
        this.lowPass.frequency.set(200.0);
        this.osc = new SawtoothOscillatorBL();
        this.synth.add(this.osc);
        this.peakFollower = new PeakFollower();
        this.synth.add(this.peakFollower);
        this.peakFollower.halfLife.set(0.2);
        this.peakScaler = new Multiply(this.peakFollower.output, this.pitchDetector.confidence);
        this.synth.add(this.peakScaler);
        this.channelIn.output.connect(0, this.lineOut.input, 0);
        this.channelIn.output.connect(this.highPass.input);
        this.highPass.output.connect(this.lowPass.input);
        this.lowPass.output.connect(this.pitchDetector.input);
        this.channelIn.output.connect(this.peakFollower.input);
        this.pitchDetector.confidence.connect(this.osc.amplitude);
        this.osc.output.connect(0, this.lineOut.input, 1);
        this.reader = new AudioStreamReader(this.synth, 2);
        this.pitchDetector.period.connect(0, this.reader.getInput(), 0);
        this.pitchDetector.confidence.connect(0, this.reader.getInput(), 1);
        this.setupGUI();
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Using " + this.pitchDetector.getClass().getName()), "North");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridLayout(0, 1));
        this.scope = new AudioScope(this.synth);
        this.scope.addProbe(this.channelIn.output);
        this.scope.addProbe(this.lowPass.output);
        this.scope.addProbe(this.osc.output);
        this.scope.addProbe(this.pitchDetector.updated);
        this.scope.setTriggerMode(AudioScope.TriggerMode.NORMAL);
        this.scope.start();
        this.scope.getView().setControlsVisible(true);
        centerPanel.add(this.scope.getView());
        this.view = new SequentialDataView();
        centerPanel.add(this.view);
        this.spectrogram = new ScrollingEdgeDisplay();
        centerPanel.add(this.spectrogram);
        this.add((Component)centerPanel, "Center");
        this.updateDiffs();
        JPanel controlPanel = new JPanel();
        this.slidingPitchDisplay = new SlidingPitchDisplay();
        controlPanel.add(this.slidingPitchDisplay);
        controlPanel.setBackground(Color.CYAN);
        this.slidingPitchDisplay.setBackground(Color.YELLOW);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        this.cpuLabel = new JLabel("CPU: ?%");
        labelPanel.add(this.cpuLabel);
        this.pitchLabel = new JLabel("Pitch: ?");
        labelPanel.add(this.pitchLabel);
        this.freqLabel = new JLabel("Freq: ? Hz");
        labelPanel.add(this.freqLabel);
        this.confidenceLabel = new JLabel("Conf: ?");
        labelPanel.add(this.confidenceLabel);
        controlPanel.add(labelPanel);
        this.add((Component)controlPanel, "South");
        this.validate();
    }

    private void updateDiffs() {
        float[] diffs = this.pitchDetector.getDiffs();
        if (diffs != null) {
            FloatSample sample = new FloatSample(diffs);
            this.view.setData(sample);
            this.view.addMarker("Period", (int)Math.round(this.pitchDetector.period.getValue()));
        }
    }

    @Override
    public void start() {
        int numInputChannels = 2;
        int numOutputChannels = 2;
        this.synth.start(44100, -1, numInputChannels, -1, numOutputChannels);
        this.lineOut.start();
        this.startDiffTimer();
        this.startSpectrumTimer();
    }

    private void startSpectrumTimer() {
        this.spectrumTimer = new Timer();
        TimerTask task = new TimerTask(){
            double[] buffer = new double[512];
            int highPitch = 90;
            int lowPitch = 24;

            @Override
            public void run() {
                while (TunerApplet.this.reader.available() >= this.buffer.length) {
                    TunerApplet.this.reader.read(this.buffer);
                    double lastMeasuredValue = 0.0;
                    int i = 0;
                    while (i < this.buffer.length) {
                        double period = this.buffer[i];
                        double confidence = this.buffer[i + 1];
                        if (confidence > 0.4 && period != lastMeasuredValue) {
                            int iconf;
                            double frequency = (double)TunerApplet.this.synth.getFrameRate() / period;
                            lastMeasuredValue = period;
                            double pitch = MidiConstants.convertFrequencyToPitch(frequency);
                            int height = TunerApplet.this.spectrogram.getHeight();
                            int y = height - (int)((double)height * (pitch - (double)this.lowPitch) / (double)(this.highPitch - this.lowPitch));
                            if (y < 0) {
                                y = 0;
                            } else if (y >= height) {
                                y = height - 1;
                            }
                            int blue = iconf = (int)(255.0 * confidence);
                            int red = 255 - iconf;
                            int argb = -16711936 + (red << 16) + blue;
                            TunerApplet.this.spectrogram.drawRGB(y, argb);
                        }
                        i += 2;
                    }
                    TunerApplet.this.spectrogram.advanceColumn();
                }
            }
        };
        this.spectrumTimer.scheduleAtFixedRate(task, 33L, 33L);
    }

    private void startDiffTimer() {
        this.diffTimer = new Timer();
        TimerTask task = new TimerTask(){
            private double lastPitch;

            @Override
            public void run() {
                TunerApplet.this.updateDiffs();
                double confidence = ((TunerApplet)TunerApplet.this).pitchDetector.confidence.getValue();
                double period = ((TunerApplet)TunerApplet.this).pitchDetector.period.getValue();
                double freq = (double)TunerApplet.this.synth.getFrameRate() / period;
                double pitch = MidiConstants.convertFrequencyToPitch(freq);
                if (confidence > 0.02 && pitch < this.lastPitch + 6.0 && pitch > this.lastPitch - 6.0) {
                    if (confidence > 0.5) {
                        int quantizedPitch = (int)Math.round(pitch);
                        double quantizedFreq = MidiConstants.convertPitchToFrequency(quantizedPitch);
                        ((TunerApplet)TunerApplet.this).osc.frequency.set(quantizedFreq);
                    }
                    TunerApplet.this.slidingPitchDisplay.setPitch(pitch);
                    TunerApplet.this.cpuLabel.setText("CPU " + (int)(TunerApplet.this.synth.getUsage() * 100.0) + "%");
                    TunerApplet.this.pitchLabel.setText(String.format("Pitch: %5.2f", pitch));
                    TunerApplet.this.freqLabel.setText(String.format("Freq: %8.2f Hz", freq));
                    TunerApplet.this.confidenceLabel.setText(String.format("Conf: %6.4f ", confidence));
                }
                TunerApplet.this.slidingPitchDisplay.setConfidence(confidence);
                this.lastPitch = pitch;
            }
        };
        this.diffTimer.scheduleAtFixedRate(task, 100L, 100L);
    }

    @Override
    public void stop() {
        this.diffTimer.cancel();
        this.spectrumTimer.cancel();
        this.synth.stop();
    }

    public static void main(String[] args) {
        TunerApplet applet = new TunerApplet();
        JAppletFrame frame = new JAppletFrame("TunerApplet", applet);
        frame.setSize(900, 900);
        frame.setVisible(true);
        frame.test();
    }
}

