/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.compose.swing;

import com.jsyn.swing.RotaryTextController;
import com.softsynth.compose.ChordProgression;
import com.softsynth.compose.ComposerThread;
import com.softsynth.compose.Scale;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ComposerView
extends JPanel {
    private ComposerThread composerThread;
    private JButton startButton;
    private JButton stopButton;
    private RotaryTextController tempoKnob;
    private RotaryTextController densityKnob;
    private RotaryTextController brightnessKnob;
    private JComboBox<Scale> scaleComboBox;
    private JComboBox<ChordProgression> chordComboBox;

    public ComposerView(ComposerThread thread) {
        this.composerThread = thread;
        this.addButtons();
    }

    private void addButtons() {
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ComposerView.this.composerThread.start();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.add(this.startButton);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ComposerView.this.composerThread.stop();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.add(this.stopButton);
        this.tempoKnob = new RotaryTextController(this.composerThread.getTempoModel(), 5);
        this.tempoKnob.setTitle("Tempo");
        this.add(this.tempoKnob);
        this.densityKnob = new RotaryTextController(this.composerThread.getDensityModel(), 5);
        this.densityKnob.setTitle("Density");
        this.add(this.densityKnob);
        this.brightnessKnob = new RotaryTextController(this.composerThread.getBrightnessModel(), 5);
        this.brightnessKnob.setTitle("Bright");
        this.add(this.brightnessKnob);
        JPanel comboPanel = new JPanel();
        comboPanel.setLayout(new GridLayout(0, 1));
        this.scaleComboBox = new JComboBox<Scale>(this.composerThread.getScaleModel());
        comboPanel.add(this.scaleComboBox);
        this.chordComboBox = new JComboBox<ChordProgression>(this.composerThread.getChordModel());
        comboPanel.add(this.chordComboBox);
        this.add(comboPanel);
    }
}

