/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.install;

import com.softsynth.install.InstallJSyn;
import com.softsynth.install.InstallerAppletFrame;
import com.softsynth.install.InstallerGUI;
import java.applet.Applet;
import java.awt.BorderLayout;

public class TriggerJSynInstallation
extends Applet
implements Runnable {
    private InstallerGUI gui;
    private boolean installJAR = false;
    private boolean isApplet = true;
    private int versionToInstall = 144;

    public static void main(String[] args) {
        TriggerJSynInstallation applet = new TriggerJSynInstallation();
        applet.isApplet = false;
        applet.installJAR = true;
        InstallerAppletFrame f = new InstallerAppletFrame(applet, "TriggerJSynInstallation Applet Frame");
        f.start();
    }

    @Override
    public void start() {
        try {
            if (this.isApplet) {
                String temp = this.getParameter("installJAR");
                if (temp != null) {
                    this.installJAR = temp.equals("yes");
                }
                if ((temp = this.getParameter("version")) != null) {
                    this.versionToInstall = Integer.parseInt(temp);
                }
            }
        }
        catch (Exception e) {
            System.out.println("getParameter() failed. Probably running as an application.");
        }
        this.gui = new InstallerGUI(this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.gui);
        this.validate();
        this.repaint();
        new Thread(this).start();
    }

    void checkFor156Bug() {
        String version = System.getProperty("java.version");
        if (version != null && version.indexOf("1.5.0_06") >= 0) {
            this.println("You are using Java version " + version + " that has a bug in its package installer.");
            this.println("We are trying to workaround the bug. You will need to restart your browser when this installation finishes.");
            this.println("If the installation fails then please upgrade to a new version of Java from " + System.getProperty("java.vendor"));
            this.installJAR = true;
        }
    }

    void print(String msg) {
        this.gui.print(msg);
    }

    void println(String msg) {
        this.gui.println(msg);
    }

    @Override
    public void stop() {
        this.removeAll();
    }

    public void checkInstallation() {
        Class cl = this.checkClass("com.softsynth.jsyn.CuePoint");
        if (cl == null) {
            String msg = "IMPORTANT: Please RESTART BROWSER before using this plugin!";
            this.gui.showMessage(msg);
        } else {
            this.gui.println("SUCCESS - the JSyn classes are present.");
            cl = this.checkClass("com.softsynth.jsyn.SynthContext");
            if (cl != null) {
                try {
                    cl.newInstance();
                    this.gui.println("SUCCESS - the JSyn native library is present.");
                }
                catch (Throwable thr) {
                    this.gui.println("ERROR - the JSyn library is MISSING!");
                }
            } else {
                this.gui.println("ERROR - the JSyn plugin is obsolete!");
            }
        }
    }

    Class checkClass(String className) {
        Class<?> cl = null;
        try {
            cl = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            cl = null;
        }
        catch (Throwable thr) {
            cl = null;
        }
        return cl;
    }

    @Override
    public void run() {
        try {
            this.checkFor156Bug();
            InstallJSyn installer = new InstallJSyn(this.gui, this.versionToInstall);
            installer.showProperties();
            installer.install(this.installJAR);
            this.gui.println("================  Check Installation ========");
            this.checkInstallation();
        }
        catch (Exception exc) {
            this.gui.println("Caught " + exc);
            this.gui.println("The JSyn Plugin installation failed.\n");
        }
    }
}

