/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.ChunkHandler;
import com.softsynth.jsyn.Synth;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ParseIFF {
    InputStream stream;
    long offset = 0L;
    long totalSize = 0L;
    public static final int LIST_ID = 1279873876;
    public static final int FORM_ID = 1179603533;

    public ParseIFF(InputStream stream) {
        this.stream = stream;
        this.offset = 0L;
    }

    public long getFileSize() {
        return this.totalSize;
    }

    public long getOffset() {
        return this.offset;
    }

    public int read() throws IOException {
        ++this.offset;
        return this.stream.read();
    }

    public int read(byte[] bar) throws IOException {
        int len = bar.length;
        int cursor = 0;
        while (cursor < len) {
            int numRead = this.stream.read(bar, cursor, len - cursor);
            if (numRead < 0) {
                return numRead;
            }
            cursor += numRead;
            this.offset += (long)numRead;
        }
        return cursor;
    }

    public long skip(long numBytes) throws IOException {
        long bytesLeft = numBytes;
        while (bytesLeft > 0L) {
            long numSkipped = this.stream.skip(bytesLeft);
            if (numSkipped < 0L) {
                return numSkipped;
            }
            bytesLeft -= numSkipped;
            this.offset += numSkipped;
        }
        return numBytes;
    }

    public int readIntBig() throws IOException {
        int result = this.read() & 0xFF;
        result = result << 8 | this.read() & 0xFF;
        result = result << 8 | this.read() & 0xFF;
        int data = this.read();
        if (data == -1) {
            throw new EOFException("readIntBig() - EOF in middle of word at offset " + this.offset);
        }
        result = result << 8 | data & 0xFF;
        return result;
    }

    public short readShortBig() throws IOException {
        short result = (short)(this.read() << 8);
        int data = this.read();
        if (data == -1) {
            throw new EOFException("readShortBig() - EOF in middle of word at offset " + this.offset);
        }
        result = (short)(result | data & 0xFF);
        return result;
    }

    public int readIntLittle() throws IOException {
        int result = this.read() & 0xFF;
        result |= (this.read() & 0xFF) << 8;
        result |= (this.read() & 0xFF) << 16;
        int data = this.read();
        if (data == -1) {
            throw new EOFException("readIntLittle() - EOF in middle of word at offset " + this.offset);
        }
        return result |= data << 24;
    }

    public short readShortLittle() throws IOException {
        short result = (short)(this.read() & 0xFF);
        int data = this.read();
        if (data == -1) {
            throw new EOFException("readShortLittle() - EOF in middle of word at offset " + this.offset);
        }
        result = (short)(result | data << 8);
        return result;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readChunkSize() throws IOException {
        return this.readIntBig();
    }

    public static String IDToString(int ID) {
        byte[] bar = new byte[]{(byte)(ID >> 24), (byte)(ID >> 16), (byte)(ID >> 8), (byte)ID};
        return new String(bar, 0);
    }

    public void parse(ChunkHandler handler) throws IOException {
        if (Synth.verbosity > 1) {
            System.out.println("parse() ------- begin");
        }
        this.offset = 0L;
        int ID = this.readIntBig();
        int numBytes = this.readChunkSize();
        this.totalSize = numBytes + 8;
        this.parseChunk(handler, ID, numBytes);
        if (Synth.verbosity > 1) {
            System.out.println("parse() ------- end");
        }
    }

    void parseForm(ChunkHandler handler, int ID, int numBytes, int type) throws IOException {
        while (numBytes > 0) {
            int ckid = this.readIntBig();
            int size = this.readChunkSize();
            numBytes -= 8;
            if (size <= 0) {
                throw new IOException("Bad IFF format. " + ParseIFF.IDToString(ckid) + ", Size = " + size);
            }
            this.parseChunk(handler, ckid, size);
            if ((size & 1) == 1) {
                ++size;
            }
            numBytes -= size;
        }
    }

    public boolean isForm(int ckid) throws IOException {
        switch (ckid) {
            case 1179603533: 
            case 1279873876: {
                return true;
            }
        }
        return false;
    }

    void parseChunk(ChunkHandler handler, int ckid, int numBytes) throws IOException {
        int numRead;
        long endOffset;
        if (Synth.verbosity > 1) {
            System.out.println("parseChunk( " + ParseIFF.IDToString(ckid) + ", " + numBytes + " )");
        }
        long startOffset = this.getOffset();
        if (this.isForm(ckid)) {
            int type = this.readIntBig();
            handler.handleForm(this, ckid, numBytes - 4, type);
            endOffset = this.getOffset();
            numRead = (int)(endOffset - startOffset);
            if (numRead < numBytes) {
                this.parseForm(handler, ckid, numBytes - numRead, type);
            }
        } else {
            handler.handleChunk(this, ckid, numBytes);
        }
        endOffset = this.getOffset();
        numRead = (int)(endOffset - startOffset);
        if ((numBytes & 1) == 1) {
            ++numBytes;
        }
        if (numRead < numBytes) {
            this.skip(numBytes - numRead);
        }
    }
}

