/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.CuePoint;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthObject;
import java.util.Vector;

public class SynthChannelData
extends SynthObject {
    int maxFrames;
    int numFrames;
    int sustainBegin = -1;
    int sustainEnd = -1;
    int releaseBegin = -1;
    int releaseEnd = -1;
    public Vector cuePoints;

    public SynthChannelData() {
        this(0);
    }

    public SynthChannelData(int maxFrames) {
        this(Synth.getSharedContext(), maxFrames);
    }

    public SynthChannelData(SynthContext synthContext, int maxFrames) {
        super(synthContext);
        this.maxFrames = maxFrames;
        this.numFrames = maxFrames;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public int getMaxFrames() {
        return this.maxFrames;
    }

    public void setNumFrames(int numFrames) {
        if (numFrames > this.maxFrames) {
            numFrames = this.maxFrames;
        }
        this.numFrames = numFrames;
    }

    public void setSustainLoop(int startFrame, int endFrame) {
        this.sustainBegin = startFrame;
        this.sustainEnd = endFrame;
    }

    public int getSustainBegin() {
        return this.sustainBegin;
    }

    public int getSustainEnd() {
        return this.sustainEnd;
    }

    public int getSustainSize() {
        return this.sustainEnd - this.sustainBegin;
    }

    public void setReleaseLoop(int startFrame, int endFrame) {
        this.releaseBegin = startFrame;
        this.releaseEnd = endFrame;
    }

    public int getReleaseBegin() {
        return this.releaseBegin;
    }

    public int getReleaseEnd() {
        return this.releaseEnd;
    }

    public int getReleaseSize() {
        return this.releaseEnd - this.releaseBegin;
    }

    public void insertSortedCue(CuePoint cuePoint) {
        if (this.cuePoints == null) {
            this.cuePoints = new Vector();
        }
        int idx = this.cuePoints.size();
        int k = 0;
        while (k < this.cuePoints.size()) {
            CuePoint cue = (CuePoint)this.cuePoints.elementAt(k);
            if (cue.getPosition() > cuePoint.getPosition()) {
                idx = k;
                break;
            }
            ++k;
        }
        this.cuePoints.insertElementAt(cuePoint, idx);
    }

    public CuePoint findCuePoint(int uniqueID) {
        if (this.cuePoints == null) {
            return null;
        }
        int num = this.cuePoints.size();
        int k = 0;
        while (k < num) {
            CuePoint cue = (CuePoint)this.cuePoints.elementAt(k);
            if (cue.getID() == uniqueID) {
                return cue;
            }
            ++k;
        }
        return null;
    }

    public int findCuePosition(int uniqueID) {
        CuePoint cue = this.findCuePoint(uniqueID);
        if (cue == null) {
            return -1;
        }
        return cue.getPosition();
    }
}

