/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.CSynAudioInterface;
import com.softsynth.jsyn.CSynInterface;
import com.softsynth.jsyn.CSynNativeImplementation;
import com.softsynth.jsyn.SharedSleeper;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthObject;
import com.softsynth.jsyn.bridge.CSynErrors;
import com.softsynth.jsyn.bridge.CSynJavaImplementation;
import com.softsynth.jsyn.view102.MessageDialog;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class SynthContext {
    private boolean gotInputPermission = false;
    private SharedSleeper sleeper;
    private Vector trackedObjects;
    protected Vector trackingThreads;
    private double suggestedInputLatency = 0.0;
    private double suggestedOutputLatency = 0.0;
    boolean deleteByGarbageCollector = true;
    private int flags = 0;
    private int openCount;
    private double millisPerTick;
    private CSynInterface csyn;
    private static CSynAudioInterface csynAudioDevice;
    private static boolean isAppletFlag;
    private static boolean appletFlagValid;

    static {
        isAppletFlag = true;
        appletFlagValid = false;
    }

    public SynthContext() {
        this(false);
    }

    public SynthContext(boolean useNative) {
        if (useNative) {
            CSynNativeImplementation impl = new CSynNativeImplementation();
            this.csyn = impl;
            if (csynAudioDevice == null) {
                csynAudioDevice = impl;
            }
        } else {
            CSynJavaImplementation impl = new CSynJavaImplementation();
            this.csyn = impl;
            if (csynAudioDevice == null) {
                csynAudioDevice = impl;
            }
        }
        this.trackedObjects = new Vector();
        this.trackingThreads = new Vector();
        this.sleeper = this.createSharedSleeper();
    }

    private void checkEngineAccess() {
        try {
            this.csyn.getVersion();
        }
        catch (Throwable th) {
            throw new SynthException(-204, "JSyn not properly installed, or web page is not calling smart_embed_jsyn.js!");
        }
    }

    public SharedSleeper createSharedSleeper() {
        return new SharedSleeper(){

            @Override
            public synchronized int bumpIndex() {
                SynthContext.this.csyn.sleepUntilTick(SynthContext.this.getTickCount() + 1);
                return SynthContext.this.getTickCount();
            }
        };
    }

    public synchronized void delete() {
        if (this.getOpenCount() <= 0) {
            this.csyn.delete();
            this.setOpenCount(0);
        }
    }

    public int debug() {
        return this.debug(1, 0);
    }

    public int debug(int command, int data) {
        return this.csyn.debug(command, data);
    }

    public static int errorCodeToText(int errorCode, byte[] text, int textSize) {
        String errorText = CSynErrors.errorCodeToText(errorCode);
        byte[] errorBytes = errorText.getBytes();
        System.arraycopy(errorBytes, 0, text, 0, errorText.length());
        return errorText.length();
    }

    public double getUsage() {
        return this.csyn.getUsage();
    }

    public int getObjectCount() {
        return this.csyn.getObjectCount();
    }

    public int getFrameCount() {
        return this.csyn.getFrameCount();
    }

    public int getTickCount() {
        return this.csyn.getTickCount();
    }

    public int getFramesPerTick() {
        return this.csyn.getFramesPerTick();
    }

    public double getFrameRate() {
        return this.csyn.getFrameRate();
    }

    public double getTickRate() {
        return this.csyn.getTickRate();
    }

    public int createUnit(int unitHash, int rate, int param) {
        return this.csyn.createUnit(unitHash, rate, param);
    }

    public int stopUnit(int unit) {
        return this.csyn.stopUnit(unit);
    }

    public int startUnit(int unit) {
        return this.csyn.startUnit(unit);
    }

    public int stopUnitAt(int time, int unit) {
        return this.csyn.stopUnitAt(time, unit);
    }

    public int startUnitAt(int time, int unit) {
        return this.csyn.startUnitAt(time, unit);
    }

    public int setPort(int token, int portHash, int partNum, double value) {
        return this.csyn.setPort(token, portHash, partNum, value);
    }

    public int setPortAt(int time, int token, int portHash, int partNum, double value) {
        return this.csyn.setPortAt(time, token, portHash, partNum, value);
    }

    public double getPort(int token, int portHash, int partNum) {
        return this.csyn.getPort(token, portHash, partNum);
    }

    public int setPortSignalType(int token, int portHash, int partNum, int signalType) {
        return this.csyn.setPortSignalType(token, portHash, partNum, signalType);
    }

    public int getPortSignalType(int token, int portHash, int partNum) {
        return this.csyn.getPortSignalType(token, portHash, partNum);
    }

    public int getNumParts(int token, int portHash) {
        return this.csyn.getNumParts(token, portHash);
    }

    public int connectUnits(int srcUnit, int srcPortHash, int srcPartNum, int dstUnit, int dstPortHash, int dstPartNum) {
        return this.csyn.connectUnits(srcUnit, srcPortHash, srcPartNum, dstUnit, dstPortHash, dstPartNum);
    }

    public int disconnectUnits(int dstUnit, int dstPortHash, int partNum) {
        return this.csyn.disconnectUnits(dstUnit, dstPortHash, partNum);
    }

    public int setPriority(int token, int priority) {
        return this.csyn.setPriority(token, priority);
    }

    public int getPriority(int token) {
        return this.csyn.getPriority(token);
    }

    public int createTable(int numFrames) {
        return this.csyn.createTable(numFrames);
    }

    public int writeTable(int table, int startFrame, int numFrames, short[] data, int startIndex, int dataLength) {
        return this.csyn.writeTable(table, startFrame, numFrames, data, startIndex, dataLength);
    }

    public int writeTableDoubles(int table, int startFrame, int numFrames, double[] data, int startIndex, int dataLength) {
        return this.csyn.writeTableDoubles(table, startFrame, numFrames, data, startIndex, dataLength);
    }

    public int useTable(int unit, int portHash, int partNum, int table) {
        return this.csyn.useTable(unit, portHash, partNum, table);
    }

    public int createEnvelope(int numFrames) {
        return this.csyn.createEnvelope(numFrames);
    }

    public int writeEnvelope(int envel, int startFrame, int numFrames, double[] data, int startIndex, int dataLength) {
        return this.csyn.writeEnvelope(envel, startFrame, numFrames, data, startIndex, dataLength);
    }

    public int readEnvelope(int envel, int startFrame, int numFrames, double[] data, int startIndex, int dataLength) {
        return this.csyn.readEnvelope(envel, startFrame, numFrames, data, startIndex, dataLength);
    }

    public int createSample(int numFrames, int channelsPerFrame) {
        return this.csyn.createSample(numFrames, channelsPerFrame);
    }

    public int writeSample(int envel, int startFrame, int numFrames, short[] data, int startIndex, int dataLength) {
        return this.csyn.writeSample(envel, startFrame, numFrames, data, startIndex, dataLength);
    }

    public int readSample(int envel, int startFrame, int numFrames, short[] data, int startIndex, int dataLength) {
        return this.csyn.readSample(envel, startFrame, numFrames, data, startIndex, dataLength);
    }

    public int clearDataQueue(int unit, int portHash) {
        return this.csyn.clearDataQueue(unit, portHash);
    }

    public int clearDataQueueAt(int time, int unit, int portHash) {
        return this.csyn.clearDataQueueAt(time, unit, portHash);
    }

    public int queueData(int unit, int portHash, int token, int startFrame, int numFrames, int flags) {
        return this.csyn.queueData(unit, portHash, token, startFrame, numFrames, flags);
    }

    public int queueDataAt(int time, int unit, int portHash, int token, int startFrame, int numFrames, int flags) {
        return this.csyn.queueDataAt(time, unit, portHash, token, startFrame, numFrames, flags);
    }

    public int getPortFrames(int token, int portHash, int partNum) {
        return this.csyn.getPortFrames(token, portHash, partNum);
    }

    /*
     * Exception decompiling
     */
    public void sleepUntilTick(int wakeUpTick) throws SynthException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void checkEngineErrors() throws SynthException {
        this.csyn.checkEngineErrors();
    }

    public void sleepForTicks(int ticks) throws SynthException {
        this.sleepUntilTick(ticks + this.getTickCount());
    }

    public synchronized void startEngine(int flags, double frameRate) throws SynthException {
        this.initialize();
        this.start(flags, frameRate);
    }

    protected final boolean askInputPermission() {
        MessageDialog dlg = new MessageDialog("This Java Applet is requesting permission to turn on the\nmicrophone or other audio input.\nPress OK to grant permission.", "OK", "DENY");
        return dlg.ask() == 0;
    }

    public synchronized void start(int flags, double frameRate, int inputDeviceID, int numInputChannels, int outputDeviceID, int numOutputChannels) throws SynthException {
        if (inputDeviceID != -1) {
            flags |= 0x20;
        }
        if (outputDeviceID == -1) {
            flags |= 0x40;
        }
        this.setFlags(flags);
        if ((flags & 0x20) != 0 && !this.gotInputPermission && SynthContext.isApplet()) {
            if (this.askInputPermission()) {
                this.gotInputPermission = true;
            } else {
                throw new SecurityException("Access to microphone denied by user.");
            }
        }
        this.sleeper.setIndex(this.getTickCount());
        this.csyn.startDevices(flags, frameRate, inputDeviceID, numInputChannels, outputDeviceID, numOutputChannels);
        this.setMillisPerTick(1000.0 / this.getTickRate());
        if (Synth.verbosity > 1) {
            System.out.println("JSyn: V" + Synth.getVersion() + ", frame rate = " + this.getFrameRate());
        }
    }

    public void start(int flags, double frameRate) throws SynthException {
        this.start(flags, frameRate, (flags & 0x20) != 0 ? SynthContext.getDefaultInputDeviceID() : -1, (flags & 0x20) != 0 ? 2 : 0, (flags & 0x40) == 0 ? SynthContext.getDefaultOutputDeviceID() : -1, (flags & 0x40) == 0 ? 2 : 0);
    }

    public void start(int flags) throws SynthException {
        this.start(flags, 44100.0);
    }

    public SharedSleeper getSleeper() {
        return this.sleeper;
    }

    public synchronized void initialize() throws SynthException {
        this.gotInputPermission = false;
        System.out.println("  java.version = " + System.getProperty("java.version") + ", java.vendor = " + System.getProperty("java.vendor") + ", os.arch = " + System.getProperty("os.arch"));
        int version = Synth.getVersion();
        if (version != 154) {
            System.err.println("Version mismatch! Java = 154, 'native = " + version);
            throw new SynthException(-201, version);
        }
        this.csyn.initialize();
        this.setOpenCount(this.getOpenCount() + 1);
    }

    public void startEngine(int flags) throws SynthException {
        this.startEngine(flags, 44100.0);
    }

    public synchronized void stopEngine() throws SynthException {
        this.stop();
        this.terminate();
    }

    public synchronized void stop() throws SynthException {
        if (this.sleeper != null) {
            this.sleeper.removeThread();
        }
        this.csyn.stop();
    }

    public synchronized void terminate() throws SynthException {
        if (Synth.verbosity > 1) {
            System.out.println("SynthContext.terminate() called.");
        }
        this.deleteAll();
        this.setOpenCount(this.getOpenCount() - 1);
        this.csyn.terminate();
    }

    void reclaim() {
        Runtime rt = Runtime.getRuntime();
        int lastNum = 0;
        int newNum = this.getObjectCount();
        while (newNum != lastNum) {
            lastNum = newNum;
            rt.gc();
            System.out.println("reclaim() - num = " + newNum);
            newNum = this.getObjectCount();
        }
        rt.runFinalization();
    }

    public int createCircuit(int[] peerArray, int flags) throws SynthException {
        int numUnits = peerArray.length;
        int token = this.csyn.createCircuit(peerArray, numUnits, flags);
        if (token < 0) {
            throw new SynthException(token, numUnits);
        }
        return token;
    }

    public int delete(SynthObject sob) {
        if (this.getOpenCount() > 0) {
            return this.csyn.delete(sob.getPeer());
        }
        return 0;
    }

    public boolean isTrackingEnabled() {
        return this.trackingThreads.contains(Thread.currentThread());
    }

    public void enableTracking(boolean ifTrack) {
        if (ifTrack) {
            this.trackingThreads.addElement(Thread.currentThread());
        } else {
            this.trackingThreads.removeElement(Thread.currentThread());
        }
    }

    public void track(SynthObject sob) {
        this.trackedObjects.addElement(sob);
    }

    public void unTrack(SynthObject sob) {
        this.trackedObjects.removeElement(sob);
    }

    public synchronized void deleteAll() throws SynthException {
        SynthObject lastSobj = null;
        while (!this.trackedObjects.isEmpty()) {
            SynthObject sobj = (SynthObject)this.trackedObjects.lastElement();
            if (sobj == lastSobj) {
                throw new SynthException("deleteAll: deleting same object twice = " + sobj);
            }
            sobj.delete();
            lastSobj = sobj;
        }
        this.trackingThreads.removeAllElements();
    }

    public void enableDeletionByGarbageCollector(boolean ifEnabled) {
        this.deleteByGarbageCollector = ifEnabled;
    }

    public void setTrace(int mask) {
        Synth.verbosity = mask;
        this.csyn.setTrace(mask);
    }

    public int getTrace() {
        return this.csyn.getTrace();
    }

    static int getNumDevices() {
        int numDevices = csynAudioDevice.getNumDevices();
        if (numDevices <= 0) {
            throw new SynthException("SynthContext must be initialized before calling getNumDevices().");
        }
        return numDevices;
    }

    static int getDefaultInputDeviceID() {
        return csynAudioDevice.getDefaultInputDeviceID();
    }

    static int getDefaultOutputDeviceID() {
        return csynAudioDevice.getDefaultOutputDeviceID();
    }

    static int getMaxInputChannels(int deviceID) {
        return csynAudioDevice.getMaxInputChannels(deviceID);
    }

    static int getMaxOutputChannels(int deviceID) {
        return csynAudioDevice.getMaxOutputChannels(deviceID);
    }

    static String getDeviceName(int deviceID) {
        byte[] text = new byte[256];
        int len = csynAudioDevice.getDeviceName(deviceID, text, text.length);
        if (len < 1) {
            throw new SynthException(len, "could not get device name");
        }
        return new String(text, 0, 0, len);
    }

    public static boolean isApplet() {
        if (appletFlagValid) {
            return isAppletFlag;
        }
        try {
            FileInputStream stream = new FileInputStream("nonExistantFile.txt");
            stream.close();
            isAppletFlag = false;
        }
        catch (SecurityException e) {
            isAppletFlag = true;
        }
        catch (IOException e) {
            isAppletFlag = false;
        }
        appletFlagValid = true;
        return isAppletFlag;
    }

    public int setSuggestedInputLatency(double latency) {
        this.suggestedInputLatency = latency;
        return csynAudioDevice.setSuggestedInputLatency(latency);
    }

    public int setSuggestedOutputLatency(double latency) {
        this.suggestedOutputLatency = latency;
        return csynAudioDevice.setSuggestedOutputLatency(latency);
    }

    public double getOutputLatency() {
        return csynAudioDevice.getOutputLatency();
    }

    public double getInputLatency() {
        return csynAudioDevice.getInputLatency();
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setMillisPerTick(double millisPerTick) {
        this.millisPerTick = millisPerTick;
    }

    public double getMillisPerTick() {
        return this.millisPerTick;
    }

    public void setOpenCount(int openCount) {
        this.openCount = openCount;
    }

    public int getOpenCount() {
        return this.openCount;
    }
}

