/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.ChunkHandler;
import com.softsynth.jsyn.CuePoint;
import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.ParseIFF;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SynthSampleAIFF
extends SynthSample
implements ChunkHandler {
    static final int AIFF_ID = 1095321158;
    static final int AIFC_ID = 1095321155;
    static final int COMM_ID = 1129270605;
    static final int SSND_ID = 1397968452;
    static final int MARK_ID = 1296126539;
    static final int INST_ID = 1229869908;
    static final int NONE_ID = 1313820229;

    public SynthSampleAIFF(SynthContext synthContext, InputStream stream) throws SynthException, IOException {
        super(synthContext);
        this.load(stream);
    }

    public SynthSampleAIFF(SynthContext synthContext) {
        super(synthContext);
    }

    public SynthSampleAIFF(InputStream stream) throws SynthException, IOException {
        this.load(stream);
    }

    public SynthSampleAIFF() {
    }

    @Override
    public short[] loadShorts(InputStream stream, boolean ifLoadData) throws SynthException, IOException {
        short[] shortData = null;
        this.ifLoadData = ifLoadData;
        this.parser = new ParseIFF(stream);
        this.parser.parse(this);
        if (ifLoadData && this.numFrames > 0) {
            shortData = this.convertBigBytesToShorts();
        }
        this.byteData = null;
        this.parser = null;
        return shortData;
    }

    double read80BitFloat() throws IOException {
        byte[] bytes = new byte[10];
        this.parser.read(bytes);
        int exp = (bytes[0] & 0x3F) << 8 | bytes[1] & 0xFF;
        int mant = (bytes[2] & 0xFF) << 16 | (bytes[3] & 0xFF) << 8 | bytes[4] & 0xFF;
        return (double)mant / (double)(1 << 22 - exp);
    }

    void parseCOMMChunk(ParseIFF parser, int ckSize) throws IOException {
        int format;
        this.channelsPerFrame = parser.readShortBig();
        this.numFrames = parser.readIntBig();
        short bitsPerSample = parser.readShortBig();
        if (bitsPerSample != 16) {
            throw new IOException("Only 16 bit samples supported.");
        }
        this.setSampleRate(this.read80BitFloat());
        if (ckSize > 18 && (format = parser.readIntBig()) != 1313820229) {
            throw new IOException("Compression not supported, format " + ParseIFF.IDToString(format));
        }
    }

    void parseINSTChunk(ParseIFF parser, int ckSize) throws IOException {
        byte pitch = parser.readByte();
        byte detune = parser.readByte();
        this.setBaseFrequency(EqualTemperedTuning.getMIDIFrequency(pitch, detune));
        pitch = parser.readByte();
        this.setLowFrequency(EqualTemperedTuning.getMIDIFrequency(pitch));
        pitch = parser.readByte();
        this.setHighFrequency(EqualTemperedTuning.getMIDIFrequency(pitch));
        parser.skip(2L);
        short gain = parser.readShortBig();
        short playMode = parser.readShortBig();
        short beginID = parser.readShortBig();
        short endID = parser.readShortBig();
        this.setSustainLoop(this.findCuePosition(beginID), this.findCuePosition(endID));
        playMode = parser.readShortBig();
        beginID = parser.readShortBig();
        endID = parser.readShortBig();
        this.setReleaseLoop(this.findCuePosition(beginID), this.findCuePosition(endID));
    }

    void parseSSNDChunk(ParseIFF parser, int ckSize) throws IOException {
        long numRead;
        int offset = parser.readIntBig();
        parser.readIntBig();
        parser.skip(offset);
        this.dataPosition = parser.getOffset();
        int numBytes = ckSize - 8 - offset;
        if (this.ifLoadData) {
            this.byteData = new byte[numBytes];
            numRead = parser.read(this.byteData);
        } else {
            numRead = parser.skip(numBytes);
        }
        if (numRead != (long)numBytes) {
            throw new EOFException("AIFF data chunk too short!");
        }
    }

    void parseMARKChunk(ParseIFF parser, int ckSize) throws IOException {
        int numCuePoints = parser.readShortBig();
        int i = 0;
        while (i < numCuePoints) {
            short uniqueID = parser.readShortBig();
            int position = parser.readIntBig();
            int len = parser.read();
            if ((len & 1) == 0) {
                ++len;
            }
            parser.skip(len);
            this.insertSortedCue(new CuePoint(position, uniqueID));
            ++i;
        }
    }

    @Override
    public void handleForm(ParseIFF parser, int ckID, int ckSize, int type) throws IOException {
        if (ckID == 1179603533 && type != 1095321158 && type != 1095321155) {
            throw new IOException("Bad AIFF form type = " + ParseIFF.IDToString(type));
        }
    }

    @Override
    public void handleChunk(ParseIFF parser, int ckID, int ckSize) throws IOException {
        switch (ckID) {
            case 1129270605: {
                this.parseCOMMChunk(parser, ckSize);
                break;
            }
            case 1397968452: {
                this.parseSSNDChunk(parser, ckSize);
                break;
            }
            case 1296126539: {
                this.parseMARKChunk(parser, ckSize);
                break;
            }
            case 1229869908: {
                this.parseINSTChunk(parser, ckSize);
                break;
            }
        }
    }
}

