/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthObject;

public class SynthTable
extends SynthObject {
    int numFrames;

    public SynthTable(SynthContext synthContext) {
        super(synthContext);
    }

    public SynthTable() {
        this(Synth.getSharedContext());
    }

    public SynthTable(SynthContext synthContext, int numFrames) throws SynthException {
        super(synthContext);
        this.allocate(numFrames);
    }

    public SynthTable(int numFrames) throws SynthException {
        this(Synth.getSharedContext(), numFrames);
    }

    public SynthTable(SynthContext synthContext, double[] data) throws SynthException {
        this(synthContext, data.length);
        this.write(data);
    }

    public SynthTable(double[] data) throws SynthException {
        this(data.length);
        this.write(data);
    }

    public void allocate(int numFrames) throws SynthException {
        this.delete();
        this.numFrames = numFrames;
        this.peerToken = this.context.createTable(numFrames);
        if (this.peerToken < 0) {
            throw new SynthException(this.peerToken, numFrames);
        }
    }

    public void write(int startFrame, int partNum, short[] data, int startIndex, int numShorts) throws SynthException {
        int result = this.context.writeTable(this.peerToken, startFrame, numShorts, data, startIndex, data.length);
        if (result < 0) {
            throw new SynthException(result, this.peerToken, startFrame);
        }
    }

    public void write(int startFrame, short[] data, int startIndex, int numShorts) throws SynthException {
        this.write(startFrame, 0, data, startIndex, numShorts);
    }

    public void write(short[] data) throws SynthException {
        this.write(0, 0, data, 0, data.length);
    }

    public void write(int startFrame, int partNum, double[] data, int startIndex, int numDoubles) throws SynthException {
        int result = this.context.writeTableDoubles(this.peerToken, startFrame, numDoubles, data, startIndex, data.length);
        if (result < 0) {
            throw new SynthException(result, this.peerToken, startFrame);
        }
    }

    public void write(int startFrame, double[] data, int startIndex, int numDoubles) throws SynthException {
        this.write(startFrame, 0, data, startIndex, numDoubles);
    }

    public void write(double[] data) throws SynthException {
        this.write(0, 0, data, 0, data.length);
    }

    public int length() {
        return this.numFrames;
    }
}

