/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthSample;
import junit.framework.TestCase;

public class TestEnvelope
extends TestCase {
    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void testReadWrite() {
        double[] data = new double[]{0.1, 0.9, 0.1, 0.7, 0.5, 0.3, 0.1, 0.0};
        SynthEnvelope envelope = new SynthEnvelope(data);
        TestEnvelope.assertEquals("Envelope numFrames", data.length / 2, envelope.getNumFrames());
        double[] buffer = new double[data.length];
        envelope.read(buffer);
        int i = 0;
        while (i < data.length) {
            TestEnvelope.assertEquals("read = write", (Object)data[i], (Object)buffer[i]);
            ++i;
        }
        this.printEnvelope(envelope);
        double[] partial = new double[]{0.2, 0.6, 0.6, 0.4};
        envelope.write(1, partial, 0, 2);
        this.printEnvelope(envelope);
        envelope.read(2, buffer, 1, 2);
        TestEnvelope.assertEquals("buffer[2]", (Object)partial[2], (Object)buffer[2]);
        TestEnvelope.assertEquals("buffer[3]", (Object)partial[3], (Object)buffer[3]);
        TestEnvelope.assertEquals("buffer[4]", (Object)buffer[6], (Object)buffer[4]);
        TestEnvelope.assertEquals("buffer[5]", (Object)buffer[7], (Object)buffer[5]);
    }

    public void testPlayRecord() {
        double[] data = new double[]{0.001, 0.7, 0.002, 0.9, 0.001, 0.7, 0.003, 0.3};
        this.checkPlayRecord(data);
    }

    public void testPlayRecordSteep() {
        double[] data = new double[]{0.0, 0.7, 0.002, 0.9, 0.001, 0.7, 0.003, 0.3};
        this.checkPlayRecord(data);
    }

    private void printEnvelope(SynthEnvelope envelope) {
        double[] buffer = new double[envelope.getNumFrames() * 2];
        envelope.read(buffer);
        System.out.println("=============");
        int i = 0;
        while (i < buffer.length) {
            System.out.println("envelope[" + i / 2 + "] = { " + buffer[i] + ", " + buffer[i + 1] + " }");
            i += 2;
        }
    }

    private void checkPlayRecord(double[] data) {
        double envDuration = 0.0;
        int i = 0;
        while (i < data.length) {
            envDuration += data[i];
            i += 2;
        }
        int envSampleFrames = (int)(envDuration * Synth.getFrameRate());
        System.out.println("envSampleFrames = " + envSampleFrames);
        SynthEnvelope envelope = new SynthEnvelope(data);
        TestEnvelope.assertEquals("Envelope numFrames", data.length / 2, envelope.getNumFrames());
        EnvelopePlayer envPlayer = new EnvelopePlayer();
        envPlayer.start();
        Synth.sleepForTicks(2);
        int extraFrames = 100;
        int framesToAllocate = envSampleFrames + extraFrames;
        SynthSample destination = new SynthSample(framesToAllocate);
        TestEnvelope.assertEquals("Sample numFrames", framesToAllocate, destination.getNumFrames());
        SampleWriter_16F1 writer = new SampleWriter_16F1();
        envPlayer.output.connect(0, writer.input, 0);
        envPlayer.envelopePort.queue(envelope);
        writer.samplePort.queue(destination);
        writer.start();
        Synth.sleepForTicks((int)(envDuration * Synth.getTickRate()) + 8);
        short[] buffer = new short[destination.getNumFrames()];
        destination.read(buffer);
        double start = 0.0;
        double end = 0.0;
        int offset = 0;
        int j = 0;
        while (j < envelope.getNumFrames()) {
            start = end;
            end = data[j * 2 + 1];
            int numFrames = (int)(data[j * 2] * Synth.getFrameRate());
            if (numFrames < 1) {
                numFrames = 1;
            }
            this.checkEnvelopeSegment(buffer, numFrames, start, end, offset);
            offset += numFrames;
            ++j;
        }
        this.checkEnvelopeSegment(buffer, extraFrames / 2, end, end, offset);
    }

    private void checkEnvelopeSegment(short[] buffer, int numFrames, double start, double end, int offset) {
        int i = 0;
        while (i < numFrames) {
            int index = i + offset;
            double expected = (end - start) * (double)i / (double)numFrames + start;
            double actual = (double)buffer[index] / 32768.0;
            TestEnvelope.assertEquals("buffer[" + index + "]", expected, actual, 0.005);
            ++i;
        }
    }
}

