/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.util.SampleQueueInputStream;
import junit.framework.TestCase;

public class TestWrapAroundBug
extends TestCase {
    public void testStreamAvailable() {
        Synth.startEngine(4);
        SineOscillator sin = new SineOscillator();
        sin.frequency.set(0, 440.0);
        sin.amplitude.set(0, 0.9);
        SampleWriter_16F1 writer = new SampleWriter_16F1();
        writer.input.connect(sin.output);
        sin.start();
        writer.start();
        SynthSample sample = new SynthSample(256);
        this.checkInputStream(sin, writer);
        writer.samplePort.queueLoop(sample);
        int ticksPerHour = (int)(Synth.getTickRate() * 60.0 * 60.0);
        int i = 0;
        while (i < 16) {
            System.out.println("Hour " + i + ", ticks = 0x" + Long.toHexString((long)Synth.getTickCount() * (long)Synth.getFramesPerTick() & 0xFFFFFFFFL));
            System.out.println("Writer frames = 0x" + Long.toHexString((long)writer.samplePort.getNumFramesMoved() & 0xFFFFFFFFL));
            Synth.sleepForTicks(ticksPerHour);
            this.checkInputStream(sin, writer);
            writer.samplePort.queueLoop(sample);
            ++i;
        }
        writer.stop();
        sin.stop();
        Synth.stopEngine();
        System.out.println("WrapAround test complete.");
    }

    private void checkInputStream(SineOscillator sin, SampleWriter_16F1 writer) {
        int sampleQueueSize = 4096;
        SampleQueueInputStream inStream = new SampleQueueInputStream(writer.samplePort, sampleQueueSize, 1);
        inStream.start(Synth.getTickCount());
        TestWrapAroundBug.assertEquals("Available samples", 0, inStream.available());
        Synth.sleepForTicks(10);
        int samplesExpected = 10 * Synth.getFramesPerTick();
        TestWrapAroundBug.assertEquals("Available samples", samplesExpected, inStream.available());
        inStream.stop(Synth.getTickCount());
    }
}

