/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.bridge;

import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.bridge.ThingTracker;
import java.util.logging.Logger;

public class ThingTable {
    private static final int MAX_THINGS = 4096;
    public static final int INVALID_TOKEN = 0;
    private ThingTracker[] things;
    private byte[] reuseCounts;
    private int thingsAllocated;
    private static int s_nextId;
    private int id;
    private static Logger s_logger;

    static {
        s_logger = Logger.getLogger(ThingTable.class.getName());
    }

    public ThingTable() {
        s_logger.fine("allocate table sized 4096");
        this.things = new ThingTracker[4096];
        this.reuseCounts = new byte[4096];
        this.id = s_nextId;
        s_logger.fine("create thing table with id = " + this.id);
        s_nextId = s_nextId + 1 & 0x7F;
    }

    public synchronized void clear() {
        int i = 0;
        while (i < this.things.length) {
            this.things[i] = null;
            ++i;
        }
        this.thingsAllocated = 0;
    }

    public synchronized int addThing(Object obj) {
        int token = 0;
        int i = 1;
        while (i < this.things.length) {
            if (this.things[i] == null) {
                this.reuseCounts[i] = (byte)(this.reuseCounts[i] + 1 & 0x7F);
                if (this.reuseCounts[i] == 0) {
                    this.reuseCounts[i] = 1;
                }
                this.things[i] = new ThingTracker();
                this.things[i].setThing(obj);
                ++this.thingsAllocated;
                token = this.indexToToken(i);
                break;
            }
            ++i;
        }
        s_logger.fine(String.format("addThing returned %x\n", token));
        if (token == 0) {
            throw new SynthException(-88, "Could not allocate a slot in token table.");
        }
        return token;
    }

    private int indexToToken(int i) {
        return (this.id << 24) + (this.reuseCounts[i] << 16) + (i & 0xFFFF);
    }

    private int tokenToIndex(int token) {
        return token & 0xFFFF;
    }

    private int tokenToReuseCount(int token) {
        return token >> 16 & 0xFF;
    }

    private int tokenToId(int token) {
        return token >> 24 & 0xFF;
    }

    public synchronized void freeToken(int token) {
        s_logger.fine(String.format("free %x\n", token));
        int index = this.tokenToIndex(token);
        this.validateToken(token, index);
        this.things[index] = null;
        --this.thingsAllocated;
    }

    public synchronized Object tokenToThing(int token) {
        s_logger.finer(String.format("lookup %x\n", token));
        int index = this.tokenToIndex(token);
        this.validateToken(token, index);
        ThingTracker tracker = this.things[index];
        if (tracker == null) {
            throw new SynthException(-98, token);
        }
        return tracker.getThing();
    }

    private void validateToken(int token, int index) {
        int reuseCount = this.tokenToReuseCount(token);
        int tokenId = this.tokenToId(token);
        if (reuseCount != this.reuseCounts[index]) {
            throw new SynthException(-98, token);
        }
        s_logger.finest("thing tokenId = " + tokenId + ",  table id = " + this.id);
        if (tokenId != this.id) {
            throw new SynthException(-98, "Token from wrong context = " + Integer.toHexString(token), tokenId, this.id);
        }
    }

    public int size() {
        return this.thingsAllocated;
    }
}

