/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthMixer;
import com.softsynth.jsyn.examples.OperatorEditor;
import com.softsynth.jsyn.view11x.UsageDisplay;
import com.softsynth.util.InsetPanel;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.PrintStream;

public class FMLab
extends Applet
implements KeyListener {
    public static final int NUM_OPERATORS = 4;
    OperatorEditor[] editors;
    OperatorEditor currentEditor;
    LineOut lineOut;
    SynthMixer mixer;
    Button keyButton;
    Button dumpButton;
    Button showButton;
    int lastNoteKey = 97;
    Checkbox onBox;
    static String keyboard = "zxcvbnmasdfghjqwertyu1234567";
    Dialog dialog;
    int lastKeyDown = -1;

    public static void main(String[] args) {
        FMLab applet = new FMLab();
        AppletFrame frame = new AppletFrame("Simple FMLab", applet);
        frame.resize(800, 600);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.dialog = new Dialog(SynthAlert.getFrame(this), "FM Lab");
        this.dialog.reshape(200, 100, 800, 600);
        this.dialog.setLayout(new BorderLayout());
        try {
            Synth.startEngine(0);
            Synth.setTrace(0);
            this.mixer = new SynthMixer(4, 1);
            this.editors = new OperatorEditor[4];
            Panel opPanel = new Panel();
            opPanel.setLayout(new GridLayout(0, 1));
            this.dialog.add("Center", opPanel);
            int i = 0;
            while (i < 4) {
                this.editors[i] = new OperatorEditor(this, i);
                InsetPanel iPanel = new InsetPanel(this.editors[i], Color.blue, 2);
                this.mixer.connectInput(i, this.editors[i].output, 0);
                this.mixer.setGain(i, 0, 0.0);
                opPanel.add(iPanel);
                ++i;
            }
            this.lineOut = new LineOut();
            this.mixer.connectOutput(0, this.lineOut.input, 0);
            this.mixer.connectOutput(0, this.lineOut.input, 1);
            this.lineOut.start();
            this.mixer.start();
            Panel controlPanel = new Panel();
            this.dialog.add("South", controlPanel);
            this.keyButton = new Button("Play Keys");
            controlPanel.add(this.keyButton);
            this.keyButton.addKeyListener(this);
            this.keyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FMLab.this.keyButton.requestFocus();
                }
            });
            this.onBox = new Checkbox("NoteOn");
            controlPanel.add(this.onBox);
            this.onBox.addKeyListener(this);
            this.onBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (FMLab.this.onBox.getState()) {
                        FMLab.this.startNoteByKey(FMLab.this.lastNoteKey);
                    } else {
                        FMLab.this.noteOff();
                    }
                }
            });
            Choice presets = new Choice();
            controlPanel.add(presets);
            presets.addKeyListener(this);
            presets.add("Simple");
            presets.add("Bell");
            presets.add("WoodDrum");
            presets.add("Brass");
            presets.add("Clarinet");
            presets.add("Trumpet");
            presets.add("Gong");
            presets.add("Woozy");
            presets.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FMLab.this.keyButton.requestFocus();
                    FMLab.this.reset();
                    if (((String)e.getItem()).equals("Simple")) {
                        FMLab.this.SimplePreset();
                    } else if (((String)e.getItem()).equals("Bell")) {
                        FMLab.this.BellPreset();
                    } else if (((String)e.getItem()).equals("WoodDrum")) {
                        FMLab.this.WoodDrumPreset();
                    } else if (((String)e.getItem()).equals("Brass")) {
                        FMLab.this.BrassPreset();
                    } else if (((String)e.getItem()).equals("Clarinet")) {
                        FMLab.this.ClarinetPreset();
                    } else if (((String)e.getItem()).equals("Trumpet")) {
                        FMLab.this.TrumpetPreset();
                    } else if (((String)e.getItem()).equals("Gong")) {
                        FMLab.this.GongPreset();
                    } else if (((String)e.getItem()).equals("Woozy")) {
                        FMLab.this.WoozyPreset();
                    }
                    FMLab.this.repaint();
                }
            });
            this.add(new UsageDisplay());
            this.showButton = new Button("Show Editor");
            this.add(this.showButton);
            this.showButton.addKeyListener(this);
            this.showButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FMLab.this.dialog != null) {
                        FMLab.this.dialog.show();
                    }
                }
            });
            this.updateDisplay();
            this.SimplePreset();
            this.dialog.show();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.removeAll();
            this.dialog.removeAll();
            this.dialog.hide();
            Synth.setTrace(0);
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    OperatorEditor getNthEditor(int index) {
        return this.editors[index];
    }

    void setOperatorMix(int index, double level) {
        this.mixer.setGain(index, 0, level);
    }

    void updateDisplay() {
        this.validate();
        this.dialog.validate();
        this.getToolkit().sync();
    }

    void reset() {
        int i = 0;
        while (i < 4) {
            this.editors[i].reset();
            ++i;
        }
    }

    void noteOn(double frequency) {
        int i = 0;
        while (i < 4) {
            this.editors[i].noteOn(frequency);
            ++i;
        }
    }

    void noteOff() {
        int i = 0;
        while (i < 4) {
            this.editors[i].noteOff();
            ++i;
        }
    }

    double convertIndexToFreq(int index) {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        int[] scale = nArray;
        int octave = index / scale.length;
        int idx = index % scale.length;
        int pitch = octave * 12 + scale[idx];
        return EqualTemperedTuning.getMIDIFrequency(pitch + 48);
    }

    boolean startNoteByKey(int key) throws SynthException {
        int index = keyboard.indexOf(key);
        if (index < 0) {
            return false;
        }
        double freq = this.convertIndexToFreq(index);
        this.noteOn(freq);
        return true;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        if (key != this.lastKeyDown) {
            this.lastKeyDown = key;
            if (this.startNoteByKey(key)) {
                this.lastNoteKey = key;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        char key = e.getKeyChar();
        if (key == this.lastKeyDown) {
            this.lastKeyDown = -1;
            this.noteOff();
        }
    }

    void dumpSource(PrintStream ps) {
        ps.println();
        ps.println("/* Java Source for an FM Preset.  Automatically generated. Do NOT edit by hand! */");
        int i = 0;
        while (i < 4) {
            ps.println("\teditor =  editors[" + i + "];");
            this.editors[i].dumpSource(ps, i);
            ++i;
        }
    }

    void SimplePreset() {
        OperatorEditor editor = this.editors[0];
        editor.setSource(1, true);
        editor.setHeard(true);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar0 = new double[]{0.1, 1.0, 0.962, 0.455, 1.232, 0.436, 0.5, 0.0};
        editor.setContour(dar0);
        editor = this.editors[1];
        editor.setHeard(false);
        editor.scaleKnob.setValue(3.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(6.449713125272715);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar1 = new double[]{0.1, 1.0, 0.064, 0.491, 0.127, 0.209, 0.5, 0.0};
        editor.setContour(dar1);
        editor = this.editors[2];
        editor.setHeard(false);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar2 = new double[]{0.1, 1.0, 0.2, 0.5, 0.5, 0.5, 0.5, 0.0};
        editor.setContour(dar2);
        editor = this.editors[3];
        editor.setHeard(false);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar3 = new double[]{0.1, 1.0, 0.2, 0.5, 0.5, 0.5, 0.5, 0.0};
        editor.setContour(dar3);
    }

    void BellPreset() {
        OperatorEditor editor = this.editors[0];
        editor.setSource(1, true);
        editor.setHeard(true);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar0 = new double[]{0.045, 0.909, 0.322, 0.545, 0.497, 0.245, 2.282, 0.055, 4.492, 0.0};
        editor.setContour(dar0);
        editor = this.editors[1];
        editor.setHeard(false);
        editor.scaleKnob.setValue(1.4);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(8.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar1 = new double[]{0.0, 0.973, 0.526, 0.345, 1.188, 0.1, 2.069, 0.0};
        editor.setContour(dar1);
        editor = this.editors[2];
        editor.setHeard(false);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar2 = new double[]{0.1, 1.0, 0.2, 0.5, 0.5, 0.5, 0.5, 0.0};
        editor.setContour(dar2);
        editor = this.editors[3];
        editor.setHeard(false);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar3 = new double[]{0.1, 1.0, 0.2, 0.5, 0.5, 0.5, 0.5, 0.0};
        editor.setContour(dar3);
    }

    void WoodDrumPreset() {
        OperatorEditor editor = this.editors[0];
        editor.setSource(1, true);
        editor.setHeard(true);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar0 = new double[]{0.0, 0.445, 0.004, 0.736, 0.014, 0.973, 0.018, 0.736, 0.031, 0.345, 0.109, 0.127, 0.058, 0.0};
        editor.setContour(dar0);
        editor = this.editors[1];
        editor.setHeard(false);
        editor.scaleKnob.setValue(0.6875);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(25.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar1 = new double[]{0.0, 0.973, 0.005, 0.245, 0.012, 0.073, 0.043, 0.0};
        editor.setContour(dar1);
        editor = this.editors[2];
        editor.setHeard(false);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar2 = new double[]{0.1, 1.0, 0.2, 0.5, 0.5, 0.5, 0.5, 0.0};
        editor.setContour(dar2);
        editor = this.editors[3];
        editor.setHeard(false);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar3 = new double[]{0.1, 1.0, 0.2, 0.5, 0.5, 0.5, 0.5, 0.0};
        editor.setContour(dar3);
    }

    void BrassPreset() {
        OperatorEditor editor = this.editors[0];
        editor.setSource(1, true);
        editor.setSource(2, true);
        editor.setHeard(true);
        editor.setFixed(false);
        editor.setSustainIndex(2);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar0 = new double[]{0.014, 0.927, 0.077, 0.627, 0.21, 0.0};
        editor.setContour(dar0);
        editor = this.editors[1];
        editor.setSource(2, true);
        editor.setHeard(false);
        editor.setFixed(false);
        editor.setSustainIndex(2);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(6.449713125272715);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar1 = new double[]{0.029, 0.955, 0.088, 0.582, 0.158, 0.0};
        editor.setContour(dar1);
        editor = this.editors[2];
        editor.setHeard(false);
        editor.setFixed(true);
        editor.setSustainIndex(-1);
        editor.scaleKnob.setValue(3.4375415772291475);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.5643362207853508);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar2 = new double[]{0.0, 0.0, 0.159, 0.0, 0.5, 0.5};
        editor.setContour(dar2);
        editor = this.editors[3];
        editor.setHeard(false);
        editor.setFixed(false);
        editor.setSustainIndex(-1);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar3 = new double[]{0.1, 1.0, 0.2, 0.5, 0.5, 0.5, 0.5, 0.0};
        editor.setContour(dar3);
    }

    void ClarinetPreset() {
        OperatorEditor editor = this.editors[0];
        editor.setSource(1, true);
        editor.setSource(2, true);
        editor.setHeard(true);
        editor.setFixed(false);
        editor.setSustainIndex(2);
        editor.scaleKnob.setValue(3.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar0 = new double[]{0.022, 0.7, 0.049, 0.912, 0.232, 0.876, 0.21, 0.0};
        editor.setContour(dar0);
        editor = this.editors[1];
        editor.setSource(2, true);
        editor.setHeard(false);
        editor.setFixed(false);
        editor.setSustainIndex(-1);
        editor.scaleKnob.setValue(2.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(4.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar1 = new double[]{0.018, 0.918, 0.021, 0.752, 0.027, 0.593, 0.1, 0.531};
        editor.setContour(dar1);
        editor = this.editors[2];
        editor.setHeard(false);
        editor.setFixed(true);
        editor.setSustainIndex(-1);
        editor.scaleKnob.setValue(1.717964842236856);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(2.3219476777485197);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar2 = new double[]{0.0, 0.0, 0.14, 0.064, 0.267, 0.273, 0.467, 0.118};
        editor.setContour(dar2);
        editor = this.editors[3];
        editor.setHeard(false);
        editor.setFixed(false);
        editor.setSustainIndex(-1);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar3 = new double[]{0.1, 1.0, 0.2, 0.5, 0.5, 0.5, 0.5, 0.0};
        editor.setContour(dar3);
    }

    void TrumpetPreset() {
        OperatorEditor editor = this.editors[0];
        editor.setSource(3, true);
        editor.setHeard(true);
        editor.setFixed(false);
        editor.setSustainIndex(2);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(-0.1);
        double[] dar0 = new double[]{0.014, 0.927, 0.094, 0.809, 0.136, 0.318, 0.335, 0.0};
        editor.setContour(dar0);
        editor = this.editors[1];
        editor.setSource(3, true);
        editor.setHeard(true);
        editor.setFixed(false);
        editor.setSustainIndex(2);
        editor.scaleKnob.setValue(6.006);
        editor.depthKnob.setValue(0.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(-10.0);
        double[] dar1 = new double[]{0.029, 0.955, 0.088, 0.791, 0.085, 0.209, 0.08, 0.0};
        editor.setContour(dar1);
        editor = this.editors[2];
        editor.setSource(3, true);
        editor.setHeard(true);
        editor.setFixed(false);
        editor.setSustainIndex(2);
        editor.scaleKnob.setValue(5.009);
        editor.depthKnob.setValue(0.5);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(-6.1);
        double[] dar2 = new double[]{0.031, 0.973, 0.175, 0.858, 0.098, 0.191, 0.047, 0.0};
        editor.setContour(dar2);
        editor = this.editors[3];
        editor.setHeard(false);
        editor.setFixed(false);
        editor.setSustainIndex(2);
        editor.scaleKnob.setValue(1.001);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(9.35406887647245);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar3 = new double[]{0.014, 0.953, 0.178, 0.827, 0.075, 0.132};
        editor.setContour(dar3);
    }

    void GongPreset() {
        OperatorEditor editor = this.editors[0];
        editor.setSource(1, true);
        editor.setSource(2, true);
        editor.setSource(3, true);
        editor.setHeard(true);
        editor.setFixed(false);
        editor.setSustainIndex(-1);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar0 = new double[]{0.045, 0.909, 0.922, 0.518, 0.917, 0.218, 2.272, 0.082, 1.916, 0.0};
        editor.setContour(dar0);
        editor = this.editors[1];
        editor.setHeard(false);
        editor.setFixed(false);
        editor.setSustainIndex(-1);
        editor.scaleKnob.setValue(1.007);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.9587270464471019);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar1 = new double[]{0.0, 0.973, 0.526, 0.345, 1.188, 0.1, 2.069, 0.009};
        editor.setContour(dar1);
        editor = this.editors[2];
        editor.setHeard(false);
        editor.setFixed(false);
        editor.setSustainIndex(-1);
        editor.scaleKnob.setValue(3.141);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(1.2361358646926257);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar2 = new double[]{0.0, 0.964, 0.006, 0.082, 0.04, 0.0};
        editor.setContour(dar2);
        editor = this.editors[3];
        editor.setHeard(false);
        editor.setFixed(false);
        editor.setSustainIndex(-1);
        editor.scaleKnob.setValue(1.1693410785057612);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(1.6917461386579746);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar3 = new double[]{0.0, 0.982, 0.345, 0.491, 0.399, 0.209, 1.503, 0.064, 2.042, 0.0};
        editor.setContour(dar3);
    }

    void WoozyPreset() {
        OperatorEditor editor = this.editors[0];
        editor.setSource(1, true);
        editor.setSource(3, true);
        editor.setHeard(true);
        editor.setFixed(false);
        editor.setSustainIndex(2);
        editor.scaleKnob.setValue(1.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.0);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar0 = new double[]{0.071, 0.945, 0.16, 0.555, 0.623, 0.0};
        editor.setContour(dar0);
        editor = this.editors[1];
        editor.setSource(2, true);
        editor.setSource(3, true);
        editor.setHeard(false);
        editor.setFixed(false);
        editor.setSustainIndex(2);
        editor.scaleKnob.setValue(0.5);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(9.821455999237836);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar1 = new double[]{0.182, 0.2, 1.139, 0.8, 0.393, 0.264, 0.73, 0.0};
        editor.setContour(dar1);
        editor = this.editors[2];
        editor.setSource(3, true);
        editor.setHeard(false);
        editor.setFixed(false);
        editor.setSustainIndex(-1);
        editor.scaleKnob.setValue(3.0);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(1.5124727965756355);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar2 = new double[]{0.0, 0.0, 0.803, 0.118, 1.256, 0.6, 0.568, 0.5, 0.536, 0.318};
        editor.setContour(dar2);
        editor = this.editors[3];
        editor.setHeard(false);
        editor.setFixed(true);
        editor.setSustainIndex(2);
        editor.scaleKnob.setValue(6.50951821486465);
        editor.depthKnob.setValue(1.0);
        editor.indexKnob.setValue(0.5372214641762998);
        editor.amplitudeKnob.setValue(0.0);
        double[] dar3 = new double[]{0.0, 0.0, 1.086, 0.927, 0.941, 0.0};
        editor.setContour(dar3);
    }
}

