/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.WhiteNoise;
import com.softsynth.jsyn.circuits.ParabolicGrain;
import com.softsynth.jsyn.circuits.PoissonTrigger;

public class GrainFarm
extends SynthNote {
    public PoissonTrigger triggerMaker;
    public ParabolicGrain[] grains;
    public BusWriter[] mixers;
    public WhiteNoise freqNoise;
    public AddUnit freqAdder;
    public AddUnit tieSpeed;
    public SynthInput probability;
    public SynthInput spread;
    public SynthInput grainSpeed;
    public BusReader busMix;
    int numGrains;

    public GrainFarm(int numGrains) throws SynthException {
        this.numGrains = numGrains;
        this.busMix = new BusReader();
        this.add(this.busMix);
        this.triggerMaker = new PoissonTrigger();
        this.add(this.triggerMaker);
        this.freqNoise = new WhiteNoise();
        this.add(this.freqNoise);
        this.freqAdder = new AddUnit();
        this.add(this.freqAdder);
        this.tieSpeed = new AddUnit();
        this.add(this.tieSpeed);
        this.grains = new ParabolicGrain[numGrains];
        this.mixers = new BusWriter[numGrains];
        int i = 0;
        while (i < numGrains) {
            this.grains[i] = new ParabolicGrain();
            this.add(this.grains[i]);
            this.mixers[i] = new BusWriter();
            this.add(this.mixers[i]);
            this.freqAdder.output.connect(this.grains[i].frequency);
            this.tieSpeed.output.connect(this.grains[i].rate);
            this.grains[i].amplitude.set(1.0 / (double)numGrains);
            this.grains[i].output.connect(this.mixers[i].input);
            this.mixers[i].busOutput.connect(this.busMix.busInput);
            if (i == 0) {
                this.triggerMaker.output.connect(this.grains[i].triggerInput);
            } else {
                this.grains[i - 1].triggerPass.connect(this.grains[i].triggerInput);
            }
            ++i;
        }
        this.freqNoise.output.connect(this.freqAdder.inputA);
        this.probability = this.triggerMaker.probability;
        this.addPort(this.probability);
        this.frequency = this.freqAdder.inputB;
        this.addPort(this.frequency, "Frequency");
        this.spread = this.freqNoise.amplitude;
        this.addPort(this.spread, "Spread");
        this.grainSpeed = this.tieSpeed.inputA;
        this.addPort(this.grainSpeed, "GrainSpeed");
        this.amplitude = this.busMix.amplitude;
        this.addPort(this.amplitude);
        this.output = this.busMix.output;
        this.addPort(this.output);
        this.frequency.setSignalType(this.grains[0].frequency);
        this.spread.setSignalType(this.grains[0].frequency);
        this.grainSpeed.setSignalType(this.grains[0].rate);
        this.spread.setup(0.0, 120.0, 1000.0);
        this.grainSpeed.setup(0.0, 60.0, 1000.0);
        this.probability.setup(0.0, 0.001, 0.03);
        this.amplitude.setup(0.0, 0.7, 0.999);
        this.frequency.setup(0.0, 800.0, 3000.0);
    }
}

