/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;

public class Noodler
extends Thread {
    SineOscillator myBeep;
    EnvelopePlayer myEnvPlayer;
    SynthEnvelope myEnv;
    LineOut myOut;
    static double maxAmp;
    int duration;
    int lastTime;
    int frequency;
    boolean keepPlaying;

    public void setupNoodler() {
        try {
            this.myBeep = new SineOscillator();
            this.myEnvPlayer = new EnvelopePlayer();
            this.myOut = new LineOut();
            this.myBeep.output.connect(this.myEnvPlayer.amplitude);
            this.myEnvPlayer.output.connect(this.myOut.input);
            double[] data = new double[]{0.1, 1.0, 0.3, 0.5, 0.8, 0.0};
            this.myEnv = new SynthEnvelope(data);
            this.myEnvPlayer.start();
            this.myBeep.start();
            this.myOut.start();
        }
        catch (SynthException e) {
            System.err.println("Error:" + e);
        }
    }

    public static void setMaxAmp(double maxAmp) {
        Noodler.maxAmp = maxAmp;
    }

    public void die() {
        this.keepPlaying = false;
    }

    @Override
    public void run() {
        try {
            this.setupNoodler();
            this.keepPlaying = true;
            while (this.keepPlaying) {
                int now = Synth.getTickCount() + 20;
                this.myBeep.amplitude.set(now, maxAmp);
                this.myBeep.frequency.set(now, Math.random() * 1040.0 + 60.0);
                this.myEnvPlayer.envelopePort.queue(now, this.myEnv);
                Synth.sleepUntilTick((int)((double)now + Math.random() * 1000.0));
            }
            this.myEnvPlayer.stop();
            this.myBeep.stop();
            this.myOut.stop();
        }
        catch (SynthException e) {
            System.err.println("Error:" + e);
        }
    }
}

