/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.AudioDevice;
import com.softsynth.jsyn.ChannelOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthUnit;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;

public class TJ_MultiChannelOut
extends Applet {
    SynthContext synthContext;
    ChannelOut[] outputs;
    SineOscillator[] sines;
    int numOutputChannels;

    public static void main(String[] args) {
        TJ_MultiChannelOut applet = new TJ_MultiChannelOut();
        AppletFrame frame = new AppletFrame("Test JSyn Multi-Channel Devices", applet);
        frame.resize(600, 300);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            this.startAudio();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    void startAudio() {
        Synth.requestVersion(142);
        this.synthContext = new SynthContext();
        this.synthContext.initialize();
        int outDevID = AudioDevice.getDefaultOutputDeviceID();
        this.numOutputChannels = AudioDevice.getMaxOutputChannels(outDevID);
        this.add(new Label("Open " + this.numOutputChannels + " audio channels.", 1));
        this.synthContext.start(0, 44100.0, -1, 0, outDevID, this.numOutputChannels);
        if (this.numOutputChannels > 0) {
            this.outputs = new ChannelOut[this.numOutputChannels];
            this.sines = new SineOscillator[this.numOutputChannels];
            int i = 0;
            while (i < this.numOutputChannels) {
                this.outputs[i] = new ChannelOut(this.synthContext, i);
                this.outputs[i].start();
                this.sines[i] = new SineOscillator(this.synthContext);
                this.sines[i].frequency.set(200.0 * (double)(i + 1));
                this.sines[i].amplitude.set(1.0);
                this.sines[i].start();
                this.sines[i].output.connect(this.outputs[i].input);
                ++i;
            }
        }
    }

    @Override
    public void stop() {
        try {
            this.stopAudio();
            this.synthContext.delete();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    void killUnits(SynthUnit[] units) {
        if (units != null) {
            int i = 0;
            while (i < units.length) {
                units[i].stop();
                units[i].delete();
                ++i;
            }
        }
    }

    void stopAudio() {
        this.killUnits(this.outputs);
        this.outputs = null;
        this.killUnits(this.sines);
        this.sines = null;
        this.synthContext.stop();
    }
}

