/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthSample;
import com.softsynth.jsyn.view102.PortFader;
import java.applet.Applet;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class TJ_Sample1
extends Applet {
    SynthSample mySamp;
    SampleReader_16V1 mySampler;
    LineOut myOut;
    final int NUM_FRAMES = 64;
    short[] data = new short[64];
    Checkbox toggle;
    SynthContext synthContext;

    public static void main(String[] args) {
        TJ_Sample1 applet = new TJ_Sample1();
        AppletFrame frame = new AppletFrame("Test SynthSample", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            this.synthContext = Synth.createSynthContext();
            this.synthContext.startEngine(0);
            this.mySamp = new SynthSample(this.synthContext, 64);
            int i = 0;
            while (i < 32) {
                this.data[i] = (short)(i * 256);
                ++i;
            }
            i = 32;
            while (i < 64) {
                this.data[i] = (short)((64 - i) * 256);
                ++i;
            }
            this.mySamp.write(this.data);
            this.mySampler = new SampleReader_16V1(this.synthContext);
            this.myOut = new LineOut(this.synthContext);
            this.mySampler.samplePort.queueLoop(this.mySamp, 0, 64);
            this.mySampler.output.connect(0, this.myOut.input, 0);
            this.mySampler.output.connect(0, this.myOut.input, 1);
            this.toggle = new Checkbox("Toggle");
            this.add(this.toggle);
            this.toggle.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (TJ_Sample1.this.toggle.getState()) {
                        TJ_Sample1.this.mySampler.samplePort.queueLoop(TJ_Sample1.this.mySamp, 0, 32);
                    } else {
                        TJ_Sample1.this.mySampler.samplePort.queueLoop(TJ_Sample1.this.mySamp, 0, 64);
                    }
                }
            });
            this.add(new PortFader(this.mySampler.amplitude, 0.7, 0.0, 1.0));
            this.add(new PortFader(this.mySampler.rate, 44100.0, 0.0, 88200.0));
            this.myOut.start();
            this.mySampler.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.mySampler.delete();
            this.mySampler = null;
            this.myOut.delete();
            this.myOut = null;
            this.removeAll();
            Synth.verbosity = 0;
            this.synthContext.stopEngine();
            this.synthContext.delete();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

