/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.PanUnit;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOscillator;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.tools.jsyn.PortKnob;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Panel;

public class TJ_SawKnob
extends Applet {
    SynthOscillator osc;
    LineOut lineOut;
    TriangleOscillator lfo;
    AddUnit adder;
    ExponentialLag myLag;
    PanUnit myPanner;
    Button ping;
    SynthContext synthContext;

    public static void main(String[] args) {
        TJ_SawKnob applet = new TJ_SawKnob();
        AppletFrame frame = new AppletFrame("Test Rotary Knobs", applet);
        frame.resize(600, 150);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        try {
            this.synthContext = new SynthContext();
            this.synthContext.setTrace(0);
            this.synthContext.startEngine(0);
            this.osc = new SawtoothOscillatorBL(this.synthContext);
            this.lfo = new TriangleOscillator(this.synthContext);
            this.adder = new AddUnit(this.synthContext);
            this.myLag = new ExponentialLag(this.synthContext);
            this.myPanner = new PanUnit(this.synthContext);
            this.lineOut = new LineOut(this.synthContext);
            this.myLag.output.connect(this.adder.inputB);
            this.lfo.output.connect(this.adder.inputA);
            this.adder.output.connect(this.osc.frequency);
            this.osc.output.connect(this.myPanner.input);
            this.myPanner.output.connect(0, this.lineOut.input, 0);
            this.myPanner.output.connect(1, this.lineOut.input, 1);
            Panel knobPanel = new Panel();
            knobPanel.setLayout(new GridLayout(1, 0));
            this.add("Center", knobPanel);
            knobPanel.add(new PortKnob(this.lfo.frequency, "ModRate (Hz)", 0.2, 0.1, 20.0, 8));
            this.lfo.amplitude.setAlias("ModDepth (Hz)");
            this.lfo.amplitude.setup(0.1, 20.0, 1000.0);
            knobPanel.add(new PortKnob(this.lfo.amplitude));
            this.myLag.input.setAlias("Frequency (Hz)");
            this.myLag.input.setup(0.1, 100.0, 1000.0);
            PortKnob pKnob = new PortKnob(this.myLag.input);
            knobPanel.add(pKnob);
            pKnob.getKnob().setTaper(1);
            knobPanel.add(new PortKnob(this.osc.amplitude, "Amplitude", 0.5, 0.0, 1.0, 8));
            knobPanel.add(new PortKnob(this.myPanner.pan, "Pan", 0.0, -1.0, 1.0, 8));
            this.myLag.halfLife.setup(0.02, 0.1, 1.0);
            knobPanel.add(new PortKnob(this.myLag.halfLife));
            this.ping = new Button("Ping");
            this.add("South", this.ping);
            this.lineOut.start();
            this.osc.start();
            this.adder.start();
            this.myLag.start();
            this.myPanner.start();
            this.lfo.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.osc.delete();
            this.lineOut.delete();
            this.lfo.delete();
            this.adder.delete();
            this.myLag.delete();
            this.osc = null;
            this.lineOut = null;
            this.lfo = null;
            this.adder = null;
            this.myLag = null;
            this.removeAll();
            this.synthContext.stopEngine();
            this.synthContext.delete();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public boolean action(Event evt, Object what) {
        try {
            if (evt.target == this.ping) {
                this.myLag.current.set(2000.0);
                return true;
            }
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
            return true;
        }
        return false;
    }
}

