/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.examples.SampleFileStreamer;
import com.softsynth.jsyn.view11x.PortFader;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

public class TJ_StreamSampleFile
extends Applet {
    private static final long serialVersionUID = -5128373198860432679L;
    Button startButton;
    Button stopButton;
    SampleFileStreamer streamer;
    LineOut myOut;
    String fileName = "/Users/phil/Desktop/attachments/StreamSampleFile/wave1_8bit.wav";

    public static void main(String[] args) {
        TJ_StreamSampleFile applet = new TJ_StreamSampleFile();
        AppletFrame frame = new AppletFrame("Stream a Sample File", applet);
        frame.setSize(600, 300);
        frame.setVisible(true);
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.requestVersion(142);
            Synth.startEngine(0);
            try {
                File sampleFile = new File(this.fileName);
                this.streamer = new SampleFileStreamer(sampleFile);
            }
            catch (IOException exc) {
                exc.printStackTrace(System.err);
                throw new RuntimeException(exc.getMessage());
            }
            this.myOut = new LineOut();
            this.streamer.getOutput().connect(0, this.myOut.input, 0);
            if (this.streamer.getOutput().getNumParts() > 1) {
                this.streamer.getOutput().connect(1, this.myOut.input, 1);
            } else {
                this.streamer.getOutput().connect(0, this.myOut.input, 1);
            }
            this.add(new PortFader(this.streamer.amplitude, 0.7, 0.0, 1.0));
            this.myOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.startButton = new Button("Start");
        this.add(this.startButton);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TJ_StreamSampleFile.this.streamer.startStream();
            }
        });
        this.stopButton = new Button("Stop");
        this.add(this.stopButton);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TJ_StreamSampleFile.this.streamer.stopStream();
            }
        });
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.streamer.stopStream();
            this.streamer.delete();
            this.streamer = null;
            this.myOut.delete();
            this.myOut = null;
            this.removeAll();
            Synth.setTrace(0);
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

