/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.perfrack;

class RecursiveSequence {
    int maxDelay;
    int delay = 1;
    int maxValue;
    int maxInterval;
    int offset = 0;
    int[] values;
    boolean[] enables;
    int cursor = 0;
    int countdown = -1;
    double actualDensity = 0.0;
    double desiredDensity = 0.5;
    int beatsPerMeasure = 8;

    public RecursiveSequence() {
        this(25, 7, 64);
    }

    public RecursiveSequence(int maxValue, int maxInterval, int arraySize) {
        this.maxDelay = arraySize / 2;
        this.values = new int[arraySize];
        this.enables = new boolean[arraySize];
        this.maxValue = maxValue;
        this.maxInterval = maxInterval;
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = maxValue / 2;
            this.enables[i] = this.isNextEnabled(false);
            ++i;
        }
    }

    void setDensity(double density) {
        this.desiredDensity = density;
    }

    double getDensity() {
        return this.desiredDensity;
    }

    void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    int getMaxValue() {
        return this.maxValue;
    }

    void setMaxInterval(int maxInterval) {
        this.maxInterval = maxInterval;
    }

    int getMaxInterval() {
        return this.maxInterval;
    }

    boolean isNextEnabled(boolean preferance) {
        double newDensity = this.actualDensity * 0.9 + (preferance ? 0.1 : 0.0);
        if (preferance && newDensity > this.desiredDensity * 0.7 + 0.3) {
            preferance = false;
        } else if (!preferance && newDensity < this.desiredDensity * 0.7) {
            preferance = true;
        }
        this.actualDensity = this.actualDensity * 0.9 + (preferance ? 0.1 : 0.0);
        return preferance;
    }

    int randomPowerOf2(int maxExp) {
        return 1 << (int)(Math.random() * (double)(maxExp + 1));
    }

    int randomEvenInterval() {
        return (int)(Math.random() * (double)(this.maxInterval * 2 + 1)) - this.maxInterval;
    }

    void calcNewOffset() {
        this.offset = this.randomEvenInterval();
    }

    void randomize() {
        this.delay = this.randomPowerOf2(4);
        this.calcNewOffset();
    }

    int next() {
        if (this.countdown-- < 0) {
            this.randomize();
            this.countdown = this.randomPowerOf2(3);
        }
        return this.nextValue();
    }

    int next(int beatIndex) {
        int beatMod = beatIndex % this.beatsPerMeasure;
        switch (beatMod) {
            case 0: {
                if (!(Math.random() < 0.9)) break;
                this.randomize();
                break;
            }
            case 2: 
            case 6: {
                if (!(Math.random() < 0.15)) break;
                this.randomize();
                break;
            }
            case 4: {
                if (!(Math.random() < 0.3)) break;
                this.randomize();
                break;
            }
            default: {
                if (!(Math.random() < 0.07)) break;
                this.randomize();
            }
        }
        return this.nextValue();
    }

    int nextValue() {
        int idx = this.cursor - this.delay;
        if (idx < 0) {
            idx += this.values.length;
        }
        int nextVal = 0;
        int timeout = 100;
        while (timeout > 0) {
            nextVal = this.values[idx] + this.offset;
            if (nextVal >= 0 && nextVal < this.maxValue) break;
            if (nextVal > this.maxValue + this.maxInterval - 1) {
                nextVal = this.maxValue;
                break;
            }
            this.calcNewOffset();
            --timeout;
        }
        if (timeout <= 0) {
            System.err.println("RecursiveSequence: nextValue timed out. offset = " + this.offset);
            nextVal = this.maxValue / 2;
            this.offset = 0;
        }
        this.values[this.cursor] = nextVal;
        boolean playIt = this.enables[this.cursor] = this.isNextEnabled(this.enables[idx]);
        ++this.cursor;
        if (this.cursor >= this.values.length) {
            this.cursor = 0;
        }
        return playIt ? nextVal : -1;
    }
}

