/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.tuna;

import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.SynthBusInput;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.examples.tuna.MelodicSequence;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.util.Random;

class TunaRiff {
    BusWriter unitBusWriter = new BusWriter();
    SynthNote unitNote;
    Random rand;
    long seedA;
    long seedB;
    Checkbox playBox;
    Checkbox changeBoxA;
    Checkbox changeBoxB;
    Checkbox useBoxA;
    Checkbox useBoxB;
    CheckboxGroup useGroup;
    boolean usingA = true;
    Panel riffPanel;
    double ampl;
    boolean started = false;

    public TunaRiff(Panel panel, String name, SynthBusInput bus, SynthNote unitNote, double ampl) throws SynthException {
        this.unitNote = unitNote;
        this.ampl = ampl;
        unitNote.output.connect(this.unitBusWriter.input);
        this.unitBusWriter.busOutput.connect(bus);
        this.rand = new Random();
        this.seedA = (long)(Math.random() * 9.223372036854776E18);
        this.seedB = (long)(Math.random() * 9.223372036854776E18);
        this.riffPanel = new Panel();
        panel.add(this.riffPanel);
        this.riffPanel.setLayout(new FlowLayout(2));
        this.riffPanel.add(new Label(name));
        this.playBox = new Checkbox("Play");
        this.riffPanel.add(this.playBox);
        this.changeBoxA = new Checkbox("ChangeA", null, true);
        this.riffPanel.add(this.changeBoxA);
        this.changeBoxB = new Checkbox("ChangeB");
        this.riffPanel.add(this.changeBoxB);
        this.useGroup = new CheckboxGroup();
        this.useBoxA = new Checkbox("UseA", this.useGroup, true);
        this.riffPanel.add(this.useBoxA);
        this.useBoxB = new Checkbox("UseB", this.useGroup, false);
        this.riffPanel.add(this.useBoxB);
    }

    public void start(int time) throws SynthException {
        this.unitNote.start(time);
        this.unitBusWriter.start(time);
        this.started = true;
    }

    public void stop(int time) throws SynthException {
        this.unitNote.stop(time);
        this.unitBusWriter.stop(time);
        this.started = false;
    }

    public boolean play(int time, MelodicSequence melody) throws SynthException {
        boolean result = false;
        if (this.playBox.getState()) {
            if (!this.started) {
                this.start(time);
            }
        } else if (this.started) {
            this.stop(time);
        }
        if (this.changeBoxA.getState()) {
            this.seedA = (long)(Math.random() * 9.223372036854776E18);
            this.changeBoxA.setState(false);
            if (this.usingA) {
                result = true;
            }
        }
        if (this.changeBoxB.getState()) {
            this.seedB = (long)(Math.random() * 9.223372036854776E18);
            this.changeBoxB.setState(false);
            if (!this.usingA) {
                result = true;
            }
        }
        if (this.useBoxA.getState()) {
            this.rand.setSeed(this.seedA);
            if (!this.usingA) {
                result = true;
            }
            this.usingA = true;
        } else {
            this.rand.setSeed(this.seedB);
            if (this.usingA) {
                result = true;
            }
            this.usingA = false;
        }
        return result;
    }
}

