/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.qa.QA_Tools;
import java.applet.Applet;
import java.awt.Component;
import java.awt.TextArea;

public class QA_Context
extends Applet {
    QA_Tools tools;
    SineOscillator sineOsc;
    AddUnit adder;
    SynthContext synthContext1;
    SynthContext synthContext2;

    public static void main(String[] args) {
        QA_Context applet = new QA_Context();
        AppletFrame frame = new AppletFrame("Load All Units", applet);
        frame.resize(600, 450);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        TextArea report = new TextArea(25, 70);
        this.add(report);
        this.tools = new QA_Tools(report);
        this.getParent().validate();
        this.getToolkit().sync();
        try {
            this.synthContext1 = new SynthContext();
            this.synthContext2 = new SynthContext();
            this.synthContext1.startEngine(0);
            this.synthContext2.startEngine(0);
            this.sineOsc = new SineOscillator(this.synthContext1);
            this.adder = new AddUnit(this.synthContext2);
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.tools.println("Attempt to connect units from two different contexts.");
        try {
            this.sineOsc.output.connect(this.adder.inputA);
            this.tools.printError("Did NOT catch connection between contexts!");
        }
        catch (SynthException e) {
            this.tools.printSuccess("Caught connection between contexts! e = " + e);
        }
        this.tools.printSummary();
    }

    @Override
    public void stop() {
        try {
            this.synthContext1.stopEngine();
            this.synthContext2.stopEngine();
            this.synthContext1.delete();
            this.synthContext2.delete();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

