/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AddUnsignedUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.BusReader;
import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.CompareUnit;
import com.softsynth.jsyn.CrossFade;
import com.softsynth.jsyn.DelayUnit;
import com.softsynth.jsyn.DivideUnit;
import com.softsynth.jsyn.DualInTwoOutUnit;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.Filter_1o1p;
import com.softsynth.jsyn.Filter_1o1p1z;
import com.softsynth.jsyn.Filter_1o1z;
import com.softsynth.jsyn.Filter_2o2p;
import com.softsynth.jsyn.Filter_2o2p2z;
import com.softsynth.jsyn.FourWayFade;
import com.softsynth.jsyn.ImpulseOscillator;
import com.softsynth.jsyn.ImpulseOscillatorBL;
import com.softsynth.jsyn.InterpolatingDelayUnit;
import com.softsynth.jsyn.LatchUnit;
import com.softsynth.jsyn.LineIn;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.LinearLag;
import com.softsynth.jsyn.MaximumUnit;
import com.softsynth.jsyn.MinimumUnit;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.MultiplyAddUnsignedUnit;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.MultiplyUnsignedUnit;
import com.softsynth.jsyn.PanControlUnit;
import com.softsynth.jsyn.PanUnit;
import com.softsynth.jsyn.ParabolicEnvelope;
import com.softsynth.jsyn.PeakFollower;
import com.softsynth.jsyn.PulseOscillator;
import com.softsynth.jsyn.PulseOscillatorBL;
import com.softsynth.jsyn.RedNoise;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.SampleReader_16F2;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.SampleWriter_16F2;
import com.softsynth.jsyn.SawtoothOscillator;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.SchmidtTrigger;
import com.softsynth.jsyn.SelectUnit;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SquareOscillator;
import com.softsynth.jsyn.SquareOscillatorBL;
import com.softsynth.jsyn.StateVariableFilter;
import com.softsynth.jsyn.SubtractUnit;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthBusInput;
import com.softsynth.jsyn.SynthBusOutput;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthEnvelopeQueue;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.jsyn.SynthSampleQueue;
import com.softsynth.jsyn.SynthTablePort;
import com.softsynth.jsyn.SynthUnit;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.jsyn.TableOscillator;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.TwoInDualOutUnit;
import com.softsynth.jsyn.WaveShaper;
import com.softsynth.jsyn.WhiteNoise;
import com.softsynth.jsyn.qa.QA_Tools;
import java.applet.Applet;
import java.awt.Component;
import java.awt.TextArea;

public class QA_LoadAll
extends Applet {
    QA_Tools tools;
    SineOscillator sine;
    SynthContext synthContext;

    public static void main(String[] args) {
        QA_LoadAll applet = new QA_LoadAll();
        AppletFrame frame = new AppletFrame("Load All Units", applet);
        frame.resize(600, 450);
        frame.show();
        frame.test();
    }

    void test(SynthUnit testUnit) throws SynthException {
        this.tools.println("Loaded " + testUnit + ", " + testUnit.getNumPorts());
        int i = 0;
        while (i < testUnit.getNumPorts()) {
            SynthPort port = testUnit.getPortAt(i);
            this.tools.print("      " + port.getName() + ":" + port.getNumParts());
            if (port instanceof SynthInput) {
                this.tools.println(", Input type = " + port.getSignalType());
                ((SynthInput)port).set(0.1);
                this.sine.output.connect((SynthInput)port);
            } else if (port instanceof SynthVariable) {
                this.tools.println(", Variable type = " + port.getSignalType());
                ((SynthVariable)port).set(0.1);
            } else if (port instanceof SynthOutput) {
                int numParts = port.getNumParts();
                this.tools.print(", Output, value = ");
                int jp = 0;
                while (jp < numParts) {
                    this.tools.print(String.valueOf(((SynthOutput)port).get(jp)) + ", ");
                    ((SynthOutput)port).connect(jp, this.sine.frequency, 0);
                    ++jp;
                }
                this.tools.println("");
            } else if (port instanceof SynthEnvelopeQueue) {
                this.tools.println(", Envelope Queue");
            } else if (port instanceof SynthSampleQueue) {
                this.tools.println(", Sample Queue");
            } else if (port instanceof SynthBusInput) {
                this.tools.println(", BusInput");
            } else if (port instanceof SynthBusOutput) {
                this.tools.println(", BusOutput");
            } else if (port instanceof SynthTablePort) {
                this.tools.println(", Table");
            } else {
                this.tools.printError(", Unrecognized type!!!!!!!!!");
            }
            ++i;
        }
    }

    @Override
    public void start() {
        TextArea report = new TextArea(25, 70);
        this.add(report);
        this.tools = new QA_Tools(report);
        this.getParent().validate();
        this.getToolkit().sync();
        try {
            this.synthContext = new SynthContext();
            this.synthContext.startEngine(0);
            this.sine = new SineOscillator(this.synthContext);
            this.test(new AddUnit(this.synthContext));
            this.test(new AddUnsignedUnit(this.synthContext));
            this.test(new BusReader(this.synthContext));
            this.test(new BusWriter(this.synthContext));
            this.test(new CompareUnit(this.synthContext));
            this.test(new CrossFade(this.synthContext));
            this.test(new DelayUnit(this.synthContext, 0.1));
            this.test(new DivideUnit(this.synthContext));
            this.test(new DualInTwoOutUnit(this.synthContext));
            this.test(new EnvelopePlayer(this.synthContext));
            this.test(new ExponentialLag(this.synthContext));
            this.test(new Filter_1o1p(this.synthContext));
            this.test(new Filter_1o1p1z(this.synthContext));
            this.test(new Filter_1o1z(this.synthContext));
            this.test(new Filter_2o2p(this.synthContext));
            this.test(new Filter_2o2p2z(this.synthContext));
            this.test(new FourWayFade(this.synthContext));
            this.test(new ImpulseOscillator(this.synthContext));
            this.test(new ImpulseOscillatorBL(this.synthContext));
            this.test(new InterpolatingDelayUnit(this.synthContext, 0.2));
            this.test(new LatchUnit(this.synthContext));
            this.test(new LineIn(this.synthContext));
            this.test(new LineOut(this.synthContext));
            this.test(new LinearLag(this.synthContext));
            this.test(new MaximumUnit(this.synthContext));
            this.test(new MinimumUnit(this.synthContext));
            this.test(new MultiplyAddUnit(this.synthContext));
            this.test(new MultiplyAddUnsignedUnit(this.synthContext));
            this.test(new MultiplyUnit(this.synthContext));
            this.test(new MultiplyUnsignedUnit(this.synthContext));
            this.test(new PanUnit(this.synthContext));
            this.test(new PanControlUnit(this.synthContext));
            this.test(new ParabolicEnvelope(this.synthContext));
            this.test(new PulseOscillator(this.synthContext));
            this.test(new PulseOscillatorBL(this.synthContext));
            this.test(new RedNoise(this.synthContext));
            this.test(new PeakFollower(this.synthContext));
            this.test(new SampleReader_16F1(this.synthContext));
            this.test(new SampleReader_16F2(this.synthContext));
            this.test(new SampleReader_16V1(this.synthContext));
            this.test(new SampleWriter_16F1(this.synthContext));
            this.test(new SampleWriter_16F2(this.synthContext));
            this.test(new SawtoothOscillator(this.synthContext));
            this.test(new SawtoothOscillatorBL(this.synthContext));
            this.test(new SchmidtTrigger(this.synthContext));
            this.test(new SelectUnit(this.synthContext));
            this.test(new SineOscillator(this.synthContext));
            this.test(new SquareOscillator(this.synthContext));
            this.test(new SquareOscillatorBL(this.synthContext));
            this.test(new StateVariableFilter(this.synthContext));
            this.test(new SubtractUnit(this.synthContext));
            this.test(new TableOscillator(this.synthContext));
            this.test(new TriangleOscillator(this.synthContext));
            this.test(new TwoInDualOutUnit(this.synthContext));
            this.test(new WaveShaper(this.synthContext));
            this.test(new WhiteNoise(this.synthContext));
            this.tools.printSummary();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.synthContext.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

