/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SampleReader_16F1;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthTable;
import com.softsynth.jsyn.qa.QA_Tools;
import java.applet.Applet;
import java.awt.Component;
import java.awt.TextArea;

public class QA_Native
extends Applet {
    QA_Tools tools;
    SineOscillator sine;
    SynthTable table;

    public static void main(String[] args) {
        QA_Native applet = new QA_Native();
        AppletFrame frame = new AppletFrame("Call Native code", applet);
        frame.resize(600, 450);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        TextArea report = new TextArea(25, 70);
        this.add(report);
        this.tools = new QA_Tools(report);
        this.getParent().validate();
        this.getToolkit().sync();
        try {
            this.tools.println("JSyn version " + Synth.getVersion());
            Synth.requestVersion(140);
            Synth.startEngine(0);
            Synth.setTrace(2);
            this.tools.println("verbosity = " + Synth.getTrace());
            LineOut lineOut = new LineOut();
            this.tools.println("LineOut input has " + lineOut.input.getNumParts() + " parts.");
            SampleReader_16F1 sr = new SampleReader_16F1();
            this.tools.println("Sampler has moved " + sr.samplePort.getNumFramesMoved(0) + " frames.");
            double[] data = new double[]{0.0, 1.0, 2.0, 3.9, 5.0, 7.0, 9.8};
            this.table = new SynthTable(data);
            this.tools.println("Wrote doubles to table.");
        }
        catch (Exception e) {
            SynthAlert.showError((Component)this, e);
        }
        catch (Error e) {
            SynthAlert.showError((Component)this, e.toString());
        }
    }

    @Override
    public void stop() {
        try {
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

