/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view;

import com.softsynth.jsyn.view.WaveTrace;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class WaveDisplay
extends Canvas {
    Vector traces = new Vector();
    int leftIndex = 0;
    int rightIndex = 512;
    int maxIndex;

    void calcMaxIndex() {
        this.maxIndex = 0;
        int j = 0;
        while (j < this.traces.size()) {
            WaveTrace trace = (WaveTrace)this.traces.elementAt(j);
            short[] data = trace.data;
            if (data.length - 1 > this.maxIndex) {
                this.maxIndex = data.length - 1;
            }
            ++j;
        }
    }

    public void setLeftIndex(int left) {
        this.leftIndex = left < 0 ? 0 : left;
    }

    public void setRightIndex(int right) {
        this.rightIndex = right > this.maxIndex ? this.maxIndex : right;
    }

    public void panLeft() {
        int delta = (this.rightIndex - this.leftIndex) / 2;
        if (this.leftIndex - delta < 0) {
            delta = this.leftIndex;
        }
        this.leftIndex -= delta;
        this.rightIndex -= delta;
    }

    public void panRight() {
        int delta = (this.rightIndex - this.leftIndex) / 2;
        if (this.rightIndex + delta > this.maxIndex) {
            delta = this.maxIndex - this.rightIndex;
        }
        this.leftIndex += delta;
        this.rightIndex += delta;
    }

    public void zoomIn() {
        int delta = (this.rightIndex - this.leftIndex) / 4;
        this.leftIndex += delta;
        this.rightIndex -= delta;
    }

    void clipIndices() {
        if (this.leftIndex < 0) {
            this.leftIndex = 0;
        }
        if (this.rightIndex > this.maxIndex) {
            this.rightIndex = this.maxIndex;
        }
    }

    public void zoomOut() {
        int delta = (this.rightIndex - this.leftIndex) / 2;
        this.leftIndex -= delta;
        this.rightIndex += delta;
        this.clipIndices();
    }

    public void addTrace(WaveTrace trace) {
        this.traces.addElement(trace);
        this.calcMaxIndex();
    }

    public void removeTrace(WaveTrace trace) {
        this.traces.removeElement(trace);
        this.calcMaxIndex();
    }

    private int shortToY(short s, int h, double scaleFactor) {
        return h * (32768 - (int)(scaleFactor * (double)s)) >> 16;
    }

    @Override
    public void paint(Graphics g) {
        int w = this.size().width;
        int h = this.size().height;
        g.setColor(Color.white);
        g.drawLine(0, h / 2, w, h / 2);
        int j = 0;
        while (j < this.traces.size()) {
            WaveTrace trace = (WaveTrace)this.traces.elementAt(j);
            double scaleFactor = trace.scaleFactor;
            g.setColor(trace.color);
            short[] data = trace.data;
            if (data.length - 1 > this.leftIndex) {
                int lastX = 0;
                int lastY = this.shortToY(data[this.leftIndex], h, scaleFactor);
                int right = data.length - 1 < this.rightIndex ? data.length - 1 : this.rightIndex;
                int i = this.leftIndex + 1;
                while (i <= right) {
                    int x = (i - this.leftIndex) * w / (right - this.leftIndex);
                    int y = this.shortToY(data[i], h, scaleFactor);
                    g.drawLine(lastX, lastY, x, y);
                    lastX = x;
                    lastY = y;
                    ++i;
                }
            }
            ++j;
        }
        g.setColor(Color.white);
        g.drawString(Integer.toString(this.leftIndex), 5, h - 20);
        g.drawString(Integer.toString(this.rightIndex), w - 40, h - 20);
    }
}

