/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view102;

import com.softsynth.jsyn.view102.WaveTrace;
import java.awt.Canvas;
import java.awt.Graphics;
import java.util.Vector;

public class WaveDisplay
extends Canvas {
    Vector traces = new Vector();
    int leftIndex = 0;
    int rightIndex = 512;
    int maxIndex;

    void calcMaxIndex() {
        this.maxIndex = 0;
        int j = 0;
        while (j < this.traces.size()) {
            WaveTrace trace = (WaveTrace)this.traces.elementAt(j);
            short[] data = trace.data;
            if (data.length - 1 > this.maxIndex) {
                this.maxIndex = data.length - 1;
            }
            ++j;
        }
        this.clipIndices();
    }

    public void setLeftIndex(int left) {
        this.leftIndex = left < 0 ? 0 : left;
        this.repaint();
    }

    public int getLeftIndex() {
        return this.leftIndex;
    }

    public void setRightIndex(int right) {
        this.rightIndex = right > this.maxIndex ? this.maxIndex : right;
        this.repaint();
    }

    public int getRightIndex() {
        return this.rightIndex;
    }

    public void panLeft(int delta) {
        if (this.leftIndex - delta < 0) {
            delta = this.leftIndex;
        }
        this.leftIndex -= delta;
        this.rightIndex -= delta;
        this.repaint();
    }

    public void panLeft() {
        int delta = (this.rightIndex - this.leftIndex) / 2;
        this.panLeft(delta);
    }

    public void panRight(int delta) {
        if (this.rightIndex + delta > this.maxIndex) {
            delta = this.maxIndex - this.rightIndex;
        }
        this.leftIndex += delta;
        this.rightIndex += delta;
        this.repaint();
    }

    public void panRight() {
        int delta = (this.rightIndex - this.leftIndex) / 2;
        this.panRight(delta);
    }

    public void zoomIn() {
        int delta = (this.rightIndex - this.leftIndex) / 4;
        this.leftIndex += delta;
        this.rightIndex -= delta;
        this.repaint();
    }

    void clipIndices() {
        if (this.rightIndex > this.maxIndex) {
            this.rightIndex = this.maxIndex;
        }
        if (this.leftIndex > this.rightIndex) {
            this.leftIndex = this.rightIndex - 1;
        }
        if (this.leftIndex < 0) {
            this.leftIndex = 0;
        }
    }

    public void zoomOut() {
        int delta = (this.rightIndex - this.leftIndex) / 2;
        if (delta < 1) {
            delta = 1;
        }
        this.leftIndex -= delta;
        this.rightIndex += delta;
        this.clipIndices();
        this.repaint();
    }

    public synchronized void addTrace(WaveTrace trace) {
        if (this.traces.size() == 0) {
            this.leftIndex = 0;
            this.rightIndex = 512;
        }
        this.traces.addElement(trace);
        this.calcMaxIndex();
    }

    public synchronized void removeTrace(WaveTrace trace) {
        this.traces.removeElement(trace);
        this.calcMaxIndex();
    }

    private int shortToY(short s, int h, double scaleFactor) {
        return h * (32768 - (int)(scaleFactor * (double)s)) >> 16;
    }

    @Override
    public void paint(Graphics g) {
        int w = this.size().width;
        int h = this.size().height;
        g.setColor(this.getForeground());
        g.drawLine(0, h / 2, w, h / 2);
        g.drawRect(0, 0, w - 1, h - 1);
        int j = 0;
        while (j < this.traces.size()) {
            WaveTrace trace = (WaveTrace)this.traces.elementAt(j);
            double scaleFactor = trace.scaleFactor;
            g.setColor(trace.color);
            short[] data = trace.data;
            if (data.length - 1 > this.leftIndex) {
                int lastX = 0;
                int lastY = this.shortToY(data[this.leftIndex], h, scaleFactor);
                int right = data.length - 1 < this.rightIndex ? data.length - 1 : this.rightIndex;
                int i = this.leftIndex + 1;
                while (i <= right) {
                    int x = (i - this.leftIndex) * w / (right - this.leftIndex);
                    int y = this.shortToY(data[i], h, scaleFactor);
                    g.drawLine(lastX, lastY, x, y);
                    lastX = x;
                    lastY = y;
                    ++i;
                }
            }
            ++j;
        }
        g.setColor(this.getForeground());
        g.drawString(Integer.toString(this.leftIndex), 5, h - 20);
        g.drawString(Integer.toString(this.rightIndex), w - 40, h - 20);
    }
}

